/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredFluidStack;
import sonar.core.api.StoredItemStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.PacketCoords;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.info.types.FluidInventoryInfo;
import sonar.logistics.info.types.FluidStackInfo;
import sonar.logistics.info.types.InventoryInfo;
import sonar.logistics.info.types.StoredStackInfo;
import sonar.logistics.network.packets.ScreenHandler;
import sonar.logistics.registries.CacheRegistry;

public class PacketScreenInteraction
extends PacketCoords {
    public BlockInteraction interact;
    public int X;
    public int Y;
    public int Z;

    public PacketScreenInteraction() {
    }

    public PacketScreenInteraction(int x, int y, int z, int X, int Y, int Z, BlockInteraction interact) {
        super(x, y, z);
        this.interact = interact;
        this.X = X;
        this.Y = Y;
        this.Z = Z;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.interact = BlockInteraction.readFromBuf((ByteBuf)buf);
        this.X = buf.readInt();
        this.Y = buf.readInt();
        this.Z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.interact.writeToBuf(buf);
        buf.writeInt(this.X);
        buf.writeInt(this.Y);
        buf.writeInt(this.Z);
    }

    public static class FluidHandler
    extends ScreenHandler<PacketFluidStack> {
        @Override
        public void handlePacket(TileEntity te, PacketFluidStack message, MessageContext ctx, ILogicInfo screenInfo, EntityPlayerMP player, boolean doubleClick) {
            ILogicInfo info;
            INetworkCache cache = null;
            if (screenInfo instanceof FluidInventoryInfo) {
                info = (FluidInventoryInfo)screenInfo;
                cache = CacheRegistry.getCache(info.cacheID);
            }
            if (screenInfo instanceof FluidStackInfo) {
                info = (FluidStackInfo)screenInfo;
                cache = CacheRegistry.getCache(((FluidStackInfo)info).cacheID);
            }
            if (message.interact.type == BlockInteractionType.RIGHT) {
                LogisticsAPI.getFluidHelper().drainHeldItem((EntityPlayer)player, cache);
            } else if (message.interact.type == BlockInteractionType.LEFT) {
                LogisticsAPI.getFluidHelper().fillHeldItem((EntityPlayer)player, cache, message.selected.setStackSize(1000L));
            } else if (message.interact.type == BlockInteractionType.SHIFT_LEFT) {
                LogisticsAPI.getFluidHelper().fillHeldItem((EntityPlayer)player, cache, message.selected);
            }
        }
    }

    public static class ItemHandler
    extends ScreenHandler<PacketItemStack> {
        @Override
        public void handlePacket(TileEntity te, PacketItemStack message, MessageContext ctx, ILogicInfo screenInfo, EntityPlayerMP player, boolean doubleClick) {
            StoredItemStack extract;
            ILogicInfo info;
            INetworkCache cache = null;
            if (screenInfo instanceof InventoryInfo) {
                info = (InventoryInfo)screenInfo;
                cache = CacheRegistry.getCache(info.cacheID);
            }
            if (screenInfo instanceof StoredStackInfo) {
                info = (StoredStackInfo)screenInfo;
                cache = CacheRegistry.getCache(((StoredStackInfo)info).cacheID);
            }
            if (message.interact.type == BlockInteractionType.RIGHT) {
                if (player.func_70694_bm() != null && message.selected.equalStack(player.func_70694_bm())) {
                    if (!doubleClick) {
                        LogisticsAPI.getItemHelper().insertItemFromPlayer((EntityPlayer)player, cache, player.field_71071_by.field_70461_c);
                    } else {
                        LogisticsAPI.getItemHelper().insertInventoryFromPlayer((EntityPlayer)player, cache, player.field_71071_by.field_70461_c);
                    }
                }
            } else if (message.interact.type != BlockInteractionType.SHIFT_RIGHT && message.selected != null && (extract = LogisticsAPI.getItemHelper().extractItem(cache, message.selected.setStackSize(message.interact.type == BlockInteractionType.LEFT ? 1L : 64L))) != null) {
                SonarAPI.getItemHelper().spawnStoredItemStack(extract, te.func_145831_w(), message.X, message.Y, message.Z, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            }
        }
    }

    public static class PacketFluidStack
    extends PacketScreenInteraction {
        public StoredFluidStack selected;

        public PacketFluidStack() {
        }

        public PacketFluidStack(int x, int y, int z, int X, int Y, int Z, BlockInteraction interact, StoredFluidStack selected) {
            super(x, y, z, X, Y, Z, interact);
            this.selected = selected;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            if (buf.readBoolean()) {
                this.selected = StoredFluidStack.readFromBuf((ByteBuf)buf);
            }
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            if (this.selected != null) {
                buf.writeBoolean(true);
                StoredFluidStack.writeToBuf((ByteBuf)buf, (StoredFluidStack)this.selected);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public static class PacketItemStack
    extends PacketScreenInteraction {
        public StoredItemStack selected;

        public PacketItemStack() {
        }

        public PacketItemStack(int x, int y, int z, int X, int Y, int Z, BlockInteraction interact, StoredItemStack selected) {
            super(x, y, z, X, Y, Z, interact);
            this.selected = selected;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.selected = StoredItemStack.readFromBuf((ByteBuf)buf);
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            StoredItemStack.writeToBuf((ByteBuf)buf, (StoredItemStack)this.selected);
        }
    }
}

