/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.logistics.Logistics;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.info.types.CategoryInfo;

public class PacketProviders
extends PacketCoords {
    public List<ILogicInfo> info;

    public PacketProviders() {
    }

    public PacketProviders(int x, int y, int z, List<ILogicInfo> info) {
        super(x, y, z);
        this.info = info;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.info = new ArrayList<ILogicInfo>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.info.add((ILogicInfo)Logistics.infoTypes.readFromBuf(buf));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.info != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.info.size());
            for (int i = 0; i < this.info.size(); ++i) {
                Logistics.infoTypes.writeToBuf(buf, this.info.get(i));
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketProviders> {
        public IMessage processMessage(PacketProviders message, TileEntity te) {
            TileHandler handler;
            Object target = FMPHelper.checkObject((Object)te);
            if (target != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof InfoReaderHandler) {
                InfoReaderHandler reader = (InfoReaderHandler)handler;
                if (message.info != null) {
                    ArrayList<ILogicInfo> newInfo = new ArrayList<ILogicInfo>();
                    ILogicInfo lastInfo = null;
                    for (ILogicInfo blockInfo : message.info) {
                        if (lastInfo == null || !lastInfo.getCategory().equals(blockInfo.getCategory())) {
                            newInfo.add(CategoryInfo.createInfo(blockInfo.getCategory()));
                        }
                        newInfo.add(blockInfo);
                        lastInfo = blockInfo;
                    }
                    reader.cachedInfo = newInfo;
                } else {
                    reader.cachedInfo = null;
                }
            }
            return null;
        }
    }
}

