/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import sonar.core.SonarCore;
import sonar.core.api.ActionType;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketStackUpdate;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.common.handlers.InventoryReaderHandler;

public class PacketInventoryReader
extends PacketCoords {
    public ItemStack selected;
    public int button;

    public PacketInventoryReader() {
    }

    public PacketInventoryReader(int x, int y, int z, ItemStack selected, int button) {
        super(x, y, z);
        this.selected = selected;
        this.button = button;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.button = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.selected != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.button);
    }

    public static class Handler
    implements IMessageHandler<PacketInventoryReader, IMessage> {
        public IMessage onMessage(PacketInventoryReader message, MessageContext ctx) {
            EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
            if (player == null || player.func_130014_f_().field_72995_K) {
                return null;
            }
            TileEntity te = player.field_70170_p.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            TileHandler target = FMPHelper.getHandler((Object)te);
            if (target != null && target instanceof InventoryReaderHandler) {
                InventoryReaderHandler reader = (InventoryReaderHandler)target;
                INetworkCache network = reader.getNetwork(te);
                if (message.button == 2) {
                    if (message.selected == null) {
                        return null;
                    }
                    LogisticsAPI.getItemHelper().removeToPlayerInventory(new StoredItemStack(message.selected), 64L, network, player, ActionType.PERFORM);
                } else {
                    if (player.field_71071_by.func_70445_o() != null) {
                        ItemStack add = player.field_71071_by.func_70445_o().func_77946_l();
                        int stackSize = Math.min(message.button == 1 ? 1 : 64, add.field_77994_a);
                        StoredItemStack stack = LogisticsAPI.getItemHelper().addItems(new StoredItemStack(add.func_77946_l()).setStackSize((long)stackSize), network, ActionType.PERFORM);
                        add.field_77994_a = stack == null || stack.stored == 0L ? (add.field_77994_a -= stackSize) : (int)((long)add.field_77994_a - ((long)stackSize - stack.stored));
                        if (add.field_77994_a <= 0) {
                            add = null;
                        }
                        if (!ItemStack.func_77989_b((ItemStack)add, (ItemStack)player.field_71071_by.func_70445_o())) {
                            player.field_71071_by.func_70437_b(add);
                            SonarCore.network.sendTo((IMessage)new PacketStackUpdate(add), (EntityPlayerMP)player);
                        }
                        return null;
                    }
                    if (player.field_71071_by.func_70445_o() == null) {
                        if (message.selected == null) {
                            return null;
                        }
                        ItemStack stack = message.selected;
                        int extractSize = Math.min(stack.func_77976_d(), 64);
                        StoredItemStack toAdd = new StoredItemStack(stack.func_77946_l()).setStackSize((long)extractSize);
                        StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(toAdd.stored, toAdd, LogisticsAPI.getItemHelper().removeItems(toAdd.copy(), network, ActionType.SIMULATE));
                        if (simulate != null && simulate.stored != 0L) {
                            StoredItemStack storedStack;
                            if (message.button == 1 && simulate.stored != 1L) {
                                simulate.setStackSize((long)Math.ceil(simulate.getStackSize() / 2L));
                            }
                            if ((storedStack = SonarAPI.getItemHelper().getStackToAdd(simulate.stored, simulate, LogisticsAPI.getItemHelper().removeItems(simulate.copy(), network, ActionType.PERFORM))) != null && storedStack.stored != 0L) {
                                player.field_71071_by.func_70437_b(storedStack.getFullStack());
                                SonarCore.network.sendTo((IMessage)new PacketStackUpdate(storedStack.getFullStack()), (EntityPlayerMP)player);
                            }
                        }
                        return null;
                    }
                }
            }
            return null;
        }
    }
}

