/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.core.utils.IBufObject;
import sonar.logistics.Logistics;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.common.handlers.EnergyReaderHandler;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.info.types.StoredEnergyInfo;

public class PacketInfoBlock
extends PacketCoords {
    public ILogicInfo info;
    public boolean primary;
    public boolean setNull;

    public PacketInfoBlock() {
    }

    public PacketInfoBlock(int x, int y, int z, boolean primary) {
        super(x, y, z);
        this.primary = primary;
        this.setNull = true;
    }

    public PacketInfoBlock(int x, int y, int z, ILogicInfo info, boolean primary) {
        super(x, y, z);
        this.info = info;
        this.primary = primary;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.setNull = buf.readBoolean();
        this.primary = buf.readBoolean();
        if (!this.setNull) {
            this.info = (ILogicInfo)Logistics.infoTypes.readFromBuf(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.setNull);
        buf.writeBoolean(this.primary);
        if (!this.setNull) {
            Logistics.infoTypes.writeToBuf(buf, this.info);
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketInfoBlock> {
        public IMessage processMessage(PacketInfoBlock message, TileEntity te) {
            TileHandler handler = FMPHelper.getHandler((Object)te);
            if (handler != null) {
                if (handler instanceof InfoReaderHandler) {
                    InfoReaderHandler reader = (InfoReaderHandler)handler;
                    if (message.primary) {
                        reader.primaryInfo.setObject((IBufObject)message.info);
                    } else {
                        reader.secondaryInfo.setObject((IBufObject)message.info);
                    }
                } else if (handler instanceof EnergyReaderHandler) {
                    EnergyReaderHandler reader = (EnergyReaderHandler)handler;
                    reader.primaryInfo.setObject((IBufObject)((StoredEnergyInfo)message.info));
                }
            }
            return null;
        }
    }
}

