/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.logistics.common.handlers.FluidReaderHandler;

public class PacketFluidReader
extends PacketCoords {
    public FluidStack selected;

    public PacketFluidReader() {
    }

    public PacketFluidReader(int x, int y, int z, FluidStack selected) {
        super(x, y, z);
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.selected = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTTagCompound tag = new NBTTagCompound();
        this.selected.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketFluidReader> {
        public IMessage processMessage(PacketFluidReader message, TileEntity te) {
            TileHandler handler;
            Object target = FMPHelper.checkObject((Object)te);
            if (target != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof FluidReaderHandler) {
                FluidReaderHandler reader = (FluidReaderHandler)handler;
                reader.current = message.selected;
            }
            return null;
        }
    }
}

