/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.logistics.api.utils.IdentifiedCoords;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class PacketDataEmitters
extends PacketCoords {
    public List<IdentifiedCoords> coords;

    public PacketDataEmitters() {
    }

    public PacketDataEmitters(int x, int y, int z, List<IdentifiedCoords> emitters) {
        super(x, y, z);
        this.coords = emitters;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.coords = new ArrayList<IdentifiedCoords>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.coords.add(IdentifiedCoords.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.coords != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.coords.size());
            for (int i = 0; i < this.coords.size(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                IdentifiedCoords.writeToNBT(tag, this.coords.get(i));
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketDataEmitters> {
        public IMessage processMessage(PacketDataEmitters message, TileEntity target) {
            if (target != null && target instanceof TileEntityDataReceiver) {
                TileEntityDataReceiver receiver = (TileEntityDataReceiver)target;
                receiver.emitters = message.coords;
            }
            return null;
        }
    }
}

