/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.common.handlers.ChannelSelectorHandler;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class PacketCoordsSelection
extends PacketCoords {
    public ExternalCoords coords;

    public PacketCoordsSelection() {
    }

    public PacketCoordsSelection(int x, int y, int z, ExternalCoords info) {
        super(x, y, z);
        this.coords = info;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.coords = ExternalCoords.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTTagCompound tag = new NBTTagCompound();
        ExternalCoords.writeToNBT(tag, this.coords);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketCoordsSelection> {
        public IMessage processMessage(PacketCoordsSelection message, TileEntity target) {
            if (!target.func_145831_w().field_72995_K) {
                if (target != null && target instanceof TileEntityDataReceiver) {
                    ((TileEntityDataReceiver)target).emitter.setCoords(message.coords.getIdentifiedCoords());
                } else {
                    TileHandler handler = FMPHelper.getHandler((Object)target);
                    if (handler != null && handler instanceof ChannelSelectorHandler) {
                        ((ChannelSelectorHandler)handler).channel.setCoords(message.coords);
                    }
                }
            }
            return null;
        }
    }
}

