/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.logistics.api.utils.IdentifiedCoords;

public class SyncIdentifiedCoords
extends SyncPart {
    private IdentifiedCoords c;
    private IdentifiedCoords last;

    public SyncIdentifiedCoords(int id) {
        super(id);
    }

    public SyncIdentifiedCoords(String name) {
        super(name);
    }

    public boolean equal() {
        if (this.c == null && this.last != null) {
            return false;
        }
        if (this.last == null) {
            return false;
        }
        return BlockCoords.equalCoords((BlockCoords)this.c.blockCoords, (BlockCoords)this.last.blockCoords) && this.c.coordString.equals(this.last.coordString);
    }

    public void setCoords(IdentifiedCoords value) {
        this.c = value;
    }

    public IdentifiedCoords getCoords() {
        return this.c;
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return false;
    }

    public void updateSync() {
        this.last = this.c;
    }

    public void writeObject(ByteBuf buf) {
        IdentifiedCoords.writeCoords(buf, this.c);
    }

    public void readObject(ByteBuf buf) {
        this.c = IdentifiedCoords.readCoords(buf);
    }

    public void writeObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag = new NBTTagCompound();
        IdentifiedCoords.writeToNBT(infoTag, this.c);
        nbt.func_74782_a(this.getTagName(), (NBTBase)infoTag);
    }

    public void readObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.c = IdentifiedCoords.readFromNBT(nbt.func_74775_l(this.getTagName()));
    }
}

