/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.logistics.api.utils.ExternalCoords;

public class SyncExternalCoords
extends SyncPart {
    private ExternalCoords c;
    private ExternalCoords last;

    public SyncExternalCoords(int id) {
        super(id);
    }

    public SyncExternalCoords(String name) {
        super(name);
    }

    public boolean equal() {
        if (this.c == null && this.last != null) {
            return false;
        }
        if (this.last == null) {
            return false;
        }
        return BlockCoords.equalCoords((BlockCoords)this.c.blockCoords, (BlockCoords)this.last.blockCoords) && this.c.coordString.equals(this.last.coordString);
    }

    public void setCoords(ExternalCoords value) {
        this.c = value;
    }

    public ExternalCoords getCoords() {
        return this.c;
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return false;
    }

    public void updateSync() {
        this.last = this.c;
    }

    public void writeObject(ByteBuf buf) {
        ExternalCoords.writeCoords(buf, this.c);
    }

    public void readObject(ByteBuf buf) {
        this.c = ExternalCoords.readCoords(buf);
    }

    public void writeObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag = new NBTTagCompound();
        ExternalCoords.writeToNBT(infoTag, this.c);
        nbt.func_74782_a(this.getTagName(), (NBTBase)infoTag);
    }

    public void readObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.c = ExternalCoords.readFromNBT(nbt.func_74775_l(this.getTagName()));
    }
}

