/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.ISyncTile;
import sonar.logistics.Logistics;
import sonar.logistics.client.gui.GuiArray;
import sonar.logistics.client.gui.GuiChannelSelector;
import sonar.logistics.client.gui.GuiClock;
import sonar.logistics.client.gui.GuiDataModifier;
import sonar.logistics.client.gui.GuiDataReceiver;
import sonar.logistics.client.gui.GuiEnergyReader;
import sonar.logistics.client.gui.GuiEntityNode;
import sonar.logistics.client.gui.GuiFluidReader;
import sonar.logistics.client.gui.GuiHammer;
import sonar.logistics.client.gui.GuiInfoCreator;
import sonar.logistics.client.gui.GuiInfoReader;
import sonar.logistics.client.gui.GuiInventoryReader;
import sonar.logistics.client.gui.GuiItemRouter;
import sonar.logistics.client.gui.GuiRedstoneSignaller;
import sonar.logistics.client.gui.GuiRenameEmitter;
import sonar.logistics.common.containers.ContainerArray;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.containers.ContainerEmptySync;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.containers.ContainerHammer;
import sonar.logistics.common.containers.ContainerInfoReader;
import sonar.logistics.common.containers.ContainerInventoryReader;
import sonar.logistics.common.containers.ContainerItemRouter;
import sonar.logistics.common.handlers.ArrayHandler;
import sonar.logistics.common.handlers.ChannelSelectorHandler;
import sonar.logistics.common.handlers.DataModifierHandler;
import sonar.logistics.common.handlers.EnergyReaderHandler;
import sonar.logistics.common.handlers.FluidReaderHandler;
import sonar.logistics.common.handlers.InfoCreatorHandler;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.common.handlers.InventoryReaderHandler;
import sonar.logistics.common.handlers.ItemRouterHandler;
import sonar.logistics.common.tileentity.TileEntityClock;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;
import sonar.logistics.common.tileentity.TileEntityDataModifier;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.common.tileentity.TileEntityHammer;
import sonar.logistics.common.tileentity.TileEntityItemRouter;
import sonar.logistics.common.tileentity.TileEntityRedstoneSignaller;
import sonar.logistics.integration.multipart.DataModifierPart;
import sonar.logistics.network.packets.PacketCoordsSelection;
import sonar.logistics.network.packets.PacketDataEmitters;
import sonar.logistics.network.packets.PacketFluidReader;
import sonar.logistics.network.packets.PacketGuiChange;
import sonar.logistics.network.packets.PacketInfoBlock;
import sonar.logistics.network.packets.PacketInventoryReader;
import sonar.logistics.network.packets.PacketProviders;
import sonar.logistics.network.packets.PacketRouterGui;
import sonar.logistics.network.packets.PacketScreenInteraction;

public class LogisticsCommon
implements IGuiHandler {
    private static final Map<String, NBTTagCompound> extendedEntityData = new HashMap<String, NBTTagCompound>();

    public static void registerPackets() {
        Logistics.network.registerMessage(PacketProviders.Handler.class, PacketProviders.class, 0, Side.CLIENT);
        Logistics.network.registerMessage(PacketInfoBlock.Handler.class, PacketInfoBlock.class, 1, Side.SERVER);
        Logistics.network.registerMessage(PacketDataEmitters.Handler.class, PacketDataEmitters.class, 2, Side.CLIENT);
        Logistics.network.registerMessage(PacketCoordsSelection.Handler.class, PacketCoordsSelection.class, 3, Side.SERVER);
        Logistics.network.registerMessage(PacketInventoryReader.Handler.class, PacketInventoryReader.class, 4, Side.SERVER);
        Logistics.network.registerMessage(PacketFluidReader.Handler.class, PacketFluidReader.class, 5, Side.SERVER);
        Logistics.network.registerMessage(PacketRouterGui.Handler.class, PacketRouterGui.class, 6, Side.SERVER);
        Logistics.network.registerMessage(PacketGuiChange.Handler.class, PacketGuiChange.class, 7, Side.SERVER);
        Logistics.network.registerMessage(PacketScreenInteraction.ItemHandler.class, PacketScreenInteraction.PacketItemStack.class, 8, Side.SERVER);
        Logistics.network.registerMessage(PacketScreenInteraction.FluidHandler.class, PacketScreenInteraction.PacketFluidStack.class, 9, Side.SERVER);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        Object entity = FMPHelper.checkObject((Object)tile);
        TileHandler handler = FMPHelper.getHandler((Object)tile);
        if (entity != null) {
            switch (ID) {
                case 1: {
                    if (handler != null && handler instanceof InfoReaderHandler) {
                        return new ContainerInfoReader((InfoReaderHandler)handler, tile);
                    }
                }
                case 2: {
                    if (entity instanceof TileEntityDataReceiver) {
                        return new ContainerDataReceiver((TileEntityDataReceiver)entity, player.field_71071_by);
                    }
                }
                case 3: {
                    if (entity instanceof TileEntityDataEmitter) {
                        return new ContainerEmptySync((TileEntity)((TileEntityDataEmitter)entity));
                    }
                }
                case 4: {
                    if (handler != null && handler instanceof InventoryReaderHandler) {
                        return new ContainerInventoryReader((InventoryReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 5: {
                    if (entity instanceof TileEntityRedstoneSignaller) {
                        return new ContainerEmptySync((TileEntity)((TileEntityRedstoneSignaller)entity));
                    }
                }
                case 6: {
                    if (handler != null && handler instanceof DataModifierHandler) {
                        return new ContainerEmptySync((ISyncTile)((DataModifierHandler)handler), tile);
                    }
                }
                case 7: {
                    if (handler != null && handler instanceof InfoCreatorHandler) {
                        return new ContainerEmptySync((ISyncTile)((InfoCreatorHandler)handler), tile);
                    }
                }
                case 8: {
                    if (entity instanceof TileEntityHammer) {
                        return new ContainerHammer(player.field_71071_by, (TileEntityHammer)((Object)entity));
                    }
                }
                case 9: {
                    if (entity instanceof TileEntityEntityNode) {
                        return new ContainerEmptySync((TileEntity)((TileEntityEntityNode)entity));
                    }
                }
                case 10: {
                    if (handler != null && handler instanceof FluidReaderHandler) {
                        return new ContainerFluidReader((FluidReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 11: {
                    if (handler != null && handler instanceof ItemRouterHandler) {
                        return new ContainerItemRouter((TileEntityItemRouter)tile, player.field_71071_by);
                    }
                }
                case 12: {
                    if (handler != null && handler instanceof ChannelSelectorHandler) {
                        return new ContainerEmptySync((ISyncTile)((ChannelSelectorHandler)handler), tile).setTypes(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
                    }
                }
                case 13: {
                    if (entity instanceof TileEntityClock) {
                        return new ContainerEmptySync((TileEntity)((TileEntityClock)entity));
                    }
                }
                case 14: {
                    if (handler != null && handler instanceof EnergyReaderHandler) {
                        return new ContainerEmptySync((ISyncTile)((EnergyReaderHandler)handler), tile).setTypes(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
                    }
                }
                case 15: {
                    if (handler == null || !(handler instanceof ArrayHandler)) break;
                    return new ContainerArray(player.field_71071_by, (ArrayHandler)handler, tile);
                }
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        Object entity = FMPHelper.checkObject((Object)tile);
        TileHandler handler = FMPHelper.getHandler((Object)tile);
        if (entity != null) {
            switch (ID) {
                case 1: {
                    if (handler != null && handler instanceof InfoReaderHandler) {
                        return new GuiInfoReader((InfoReaderHandler)handler, tile);
                    }
                }
                case 2: {
                    if (entity instanceof TileEntityDataReceiver) {
                        return new GuiDataReceiver(player.field_71071_by, (TileEntityDataReceiver)entity);
                    }
                }
                case 3: {
                    if (entity instanceof TileEntityDataEmitter) {
                        return new GuiRenameEmitter((TileEntityDataEmitter)entity);
                    }
                }
                case 4: {
                    if (handler != null && handler instanceof InventoryReaderHandler) {
                        return new GuiInventoryReader((InventoryReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 5: {
                    if (entity instanceof TileEntityRedstoneSignaller) {
                        return new GuiRedstoneSignaller.RedstoneSignaller((TileEntityRedstoneSignaller)entity);
                    }
                }
                case 6: {
                    if ((entity instanceof TileEntityDataModifier || entity instanceof DataModifierPart) && handler != null && handler instanceof DataModifierHandler) {
                        return new GuiDataModifier((DataModifierHandler)handler, tile);
                    }
                }
                case 7: {
                    if (handler != null && handler instanceof InfoCreatorHandler) {
                        return new GuiInfoCreator((InfoCreatorHandler)handler, tile);
                    }
                }
                case 8: {
                    if (entity instanceof TileEntityHammer) {
                        return new GuiHammer(player.field_71071_by, (TileEntityHammer)((Object)entity));
                    }
                }
                case 9: {
                    if (entity instanceof TileEntityEntityNode) {
                        return new GuiEntityNode((TileEntityEntityNode)entity);
                    }
                }
                case 10: {
                    if (handler != null && handler instanceof FluidReaderHandler) {
                        return new GuiFluidReader((FluidReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 11: {
                    if (handler != null && handler instanceof ItemRouterHandler) {
                        return new GuiItemRouter((ItemRouterHandler)handler, (TileEntityItemRouter)tile, player);
                    }
                }
                case 12: {
                    if (handler != null && handler instanceof ChannelSelectorHandler) {
                        return new GuiChannelSelector(tile, (ChannelSelectorHandler)handler, player.field_71071_by);
                    }
                }
                case 13: {
                    if (entity instanceof TileEntityClock) {
                        return new GuiClock((TileEntityClock)entity);
                    }
                }
                case 14: {
                    if (handler != null && handler instanceof EnergyReaderHandler) {
                        return new GuiEnergyReader(tile, (EnergyReaderHandler)handler, player.field_71071_by);
                    }
                }
                case 15: {
                    if (handler == null || !(handler instanceof ArrayHandler)) break;
                    return new GuiArray(player.field_71071_by, (ArrayHandler)handler, tile);
                }
            }
        }
        return null;
    }

    public void registerRenderThings() {
    }
}

