/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.common.handlers.InventoryReaderHandler;
import sonar.logistics.integration.multipart.ConnectionPart;
import sonar.logistics.integration.multipart.ForgeMultipartHandler;
import sonar.logistics.registries.BlockRegistry;

public class InventoryReaderPart
extends ConnectionPart
implements IInfoEmitter {
    public InventoryReaderHandler handler = new InventoryReaderHandler(true);

    public InventoryReaderPart() {
    }

    public InventoryReaderPart(int meta) {
        super(meta);
    }

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return this.handler.canConnect((TileEntity)this.tile(), dir);
    }

    @Override
    public ILogicInfo currentInfo() {
        return this.handler.currentInfo((TileEntity)this.tile());
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition pos, ItemStack stack) {
        if (player != null) {
            this.sendSyncPacket(player);
            player.openGui((Object)Logistics.instance, 4, this.tile().func_145831_w(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    public Cuboid6 getBounds() {
        if (this.meta == 2 || this.meta == 3) {
            return new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
        }
        if (this.meta == 4 || this.meta == 5) {
            return new Cuboid6(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
        }
        return new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.InventoryReader();
    }

    @Override
    public ForgeMultipartHandler.MultiPart getPartType() {
        return ForgeMultipartHandler.MultiPart.INV_READER;
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this.tile());
    }

    @Override
    public void addConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile()));
        LogisticsAPI.getCableHelper().addConnection((TileEntity)this.tile(), dir);
    }

    @Override
    public void removeConnections() {
        LogisticsAPI.getCableHelper().removeConnection((TileEntity)this.tile(), ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile())));
    }

    public Block getBlock() {
        return BlockRegistry.inventoryReader;
    }
}

