/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.ITextField;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.common.handlers.InfoCreatorHandler;
import sonar.logistics.integration.multipart.ConnectionPart;
import sonar.logistics.integration.multipart.ForgeMultipartHandler;
import sonar.logistics.registries.BlockRegistry;

public class InfoCreatorPart
extends ConnectionPart
implements IInfoEmitter,
ICableRenderer,
ITextField {
    public InfoCreatorHandler handler = new InfoCreatorHandler(true, (TileEntity)this.tile());

    public InfoCreatorPart() {
    }

    public InfoCreatorPart(int meta) {
        super(meta);
    }

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return this.handler.canConnect((TileEntity)this.tile(), dir);
    }

    @Override
    public ILogicInfo currentInfo() {
        return this.handler.currentInfo();
    }

    public void textTyped(String string, int id) {
        this.handler.textTyped(string, id);
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        return this.handler.canRenderConnection((TileEntity)this.tile(), dir);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition pos, ItemStack stack) {
        if (player != null) {
            player.openGui((Object)Logistics.instance, 7, this.tile().func_145831_w(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    @Override
    public ForgeMultipartHandler.MultiPart getPartType() {
        return ForgeMultipartHandler.MultiPart.INFO_CREATOR;
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.InfoCreator();
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this.tile());
    }

    @Override
    public void addConnections() {
        LogisticsAPI.getCableHelper().addConnection((TileEntity)this.tile(), ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile())));
    }

    @Override
    public void removeConnections() {
        LogisticsAPI.getCableHelper().removeConnection((TileEntity)this.tile(), ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile())));
    }

    public Block getBlock() {
        return BlockRegistry.infoCreator;
    }
}

