/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import sonar.logistics.Logistics;
import sonar.logistics.integration.multipart.ChannelledCablePart;
import sonar.logistics.integration.multipart.DataCablePart;
import sonar.logistics.integration.multipart.DataModifierPart;
import sonar.logistics.integration.multipart.DisplayScreenPart;
import sonar.logistics.integration.multipart.EnergyReaderPart;
import sonar.logistics.integration.multipart.FluidReaderPart;
import sonar.logistics.integration.multipart.InfoCreatorPart;
import sonar.logistics.integration.multipart.InfoReaderPart;
import sonar.logistics.integration.multipart.InventoryReaderPart;
import sonar.logistics.registries.BlockRegistry;

public class ForgeMultipartHandler
implements MultiPartRegistry.IPartFactory,
MultiPartRegistry.IPartConverter {
    public static ForgeMultipartHandler instance;

    public static void init() {
        instance = new ForgeMultipartHandler();
        MultiPartRegistry.registerConverter((MultiPartRegistry.IPartConverter)instance);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)instance, (String[])MultiPart.getNames());
    }

    public Iterable<Block> blockTypes() {
        return Arrays.asList(BlockRegistry.displayScreen, BlockRegistry.dataCable, BlockRegistry.infoReader, BlockRegistry.inventoryReader, BlockRegistry.infoCreator, BlockRegistry.dataModifier, BlockRegistry.fluidReader, BlockRegistry.channelledCable, BlockRegistry.energyReader);
    }

    public TMultiPart createPart(String name, boolean client) {
        MultiPart part = MultiPart.getPart(name);
        if (part != null) {
            switch (part) {
                case DISPLAY_SCREEN: {
                    return new DisplayScreenPart();
                }
                case DATA_CABLE: {
                    return new DataCablePart();
                }
                case INFO_READER: {
                    return new InfoReaderPart();
                }
                case INV_READER: {
                    return new InventoryReaderPart();
                }
                case INFO_CREATOR: {
                    return new InfoCreatorPart();
                }
                case DATA_MODIFIER: {
                    return new DataModifierPart();
                }
                case FLUID_READER: {
                    return new FluidReaderPart();
                }
                case CHANNELLED_CABLE: {
                    return new ChannelledCablePart();
                }
                case ENERGY_READER: {
                    return new EnergyReaderPart();
                }
            }
        }
        return null;
    }

    public TMultiPart convert(World world, BlockCoord pos) {
        Block b = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (b == BlockRegistry.displayScreen) {
            return new DisplayScreenPart(meta);
        }
        if (b == BlockRegistry.dataCable) {
            return new DataCablePart(meta);
        }
        if (b == BlockRegistry.infoReader) {
            return new InfoReaderPart(meta);
        }
        if (b == BlockRegistry.inventoryReader) {
            return new InventoryReaderPart(meta);
        }
        if (b == BlockRegistry.infoCreator) {
            return new InfoCreatorPart(meta);
        }
        if (b == BlockRegistry.dataModifier) {
            return new DataModifierPart(meta);
        }
        if (b == BlockRegistry.fluidReader) {
            return new FluidReaderPart(meta);
        }
        if (b == BlockRegistry.channelledCable) {
            return new ChannelledCablePart(meta);
        }
        if (b == BlockRegistry.energyReader) {
            return new EnergyReaderPart(meta);
        }
        return null;
    }

    public static enum MultiPart {
        DISPLAY_SCREEN("Screen Part"),
        DATA_CABLE("Cable Part"),
        INFO_READER("Info Reader"),
        INV_READER("Inventory Reader"),
        INFO_CREATOR("Info Creator"),
        DATA_MODIFIER("Data Modifier"),
        FLUID_READER("Fluid Reader"),
        CHANNELLED_CABLE("Multi Cable Part"),
        ENERGY_READER("EnergyReader");

        public String name;

        private MultiPart(String name) {
            this.name = name;
        }

        public static String[] getNames() {
            String[] names = new String[MultiPart.values().length];
            for (int i = 0; i < MultiPart.values().length; ++i) {
                names[i] = MultiPart.values()[i].name;
            }
            return names;
        }

        public static MultiPart getPart(String name) {
            for (MultiPart part : MultiPart.values()) {
                if (!part.name.equals(name)) continue;
                return part;
            }
            Logistics.logger.error("NO MULTIPART NAMED: " + name);
            return null;
        }
    }
}

