/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.ITextField;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.common.handlers.DataModifierHandler;
import sonar.logistics.integration.multipart.ConnectionPart;
import sonar.logistics.integration.multipart.ForgeMultipartHandler;
import sonar.logistics.registries.BlockRegistry;

public class DataModifierPart
extends ConnectionPart
implements IInfoEmitter,
ICableRenderer,
ITextField {
    public DataModifierHandler handler = new DataModifierHandler(true, (TileEntity)this.tile());

    public DataModifierPart() {
    }

    public DataModifierPart(int meta) {
        super(meta);
    }

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return this.handler.canConnect(dir);
    }

    @Override
    public ILogicInfo currentInfo() {
        return this.handler.currentInfo();
    }

    public void textTyped(String string, int id) {
        this.handler.textTyped(string, id);
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        return this.handler.canRenderConnection(dir, (TileEntity)this.tile());
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition pos, ItemStack stack) {
        if (player != null) {
            player.openGui((Object)Logistics.instance, 6, this.tile().func_145831_w(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    @Override
    public ForgeMultipartHandler.MultiPart getPartType() {
        return ForgeMultipartHandler.MultiPart.DATA_MODIFIER;
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.DataModifier();
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this.tile());
    }

    @Override
    public void addConnections() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile())).getOpposite()) continue;
            LogisticsAPI.getCableHelper().addConnection((TileEntity)this.tile(), dir);
        }
    }

    @Override
    public void removeConnections() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this.tile())).getOpposite()) continue;
            LogisticsAPI.getCableHelper().removeConnection((TileEntity)this.tile(), dir);
        }
    }

    public Block getBlock() {
        return BlockRegistry.dataModifier;
    }
}

