/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.integration.multipart.ForgeMultipartHandler;
import sonar.logistics.integration.multipart.LogisticsPart;
import sonar.logistics.registries.BlockRegistry;

public class ChannelledCablePart
extends LogisticsPart
implements IDataCable,
JNormalOcclusion {
    public int registryID = -1;
    public boolean occlusion;
    final double SHORTER = 0.375;
    final double LONGER = 0.625;
    final double MIN_DIRECTION = 0.0;
    final double MAX_DIRECTION = 1.0;
    final Cuboid6[] SIDE_TESTS = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0), new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)};

    public ChannelledCablePart() {
    }

    public ChannelledCablePart(int meta) {
        super(meta);
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.ChannelledCable();
    }

    @Override
    public ForgeMultipartHandler.MultiPart getPartType() {
        return ForgeMultipartHandler.MultiPart.CHANNELLED_CABLE;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (this.occlusion) {
            return Collections.emptyList();
        }
        return super.getOcclusionBoxes();
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN || this.tile() == null) {
            return false;
        }
        this.occlusion = true;
        boolean blocked = !this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(this.SIDE_TESTS[side.ordinal()]));
        this.occlusion = false;
        return blocked;
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        if (this.isBlocked(dir)) {
            return CableType.NONE;
        }
        return LogisticsAPI.getCableHelper().canRenderConnection((TileEntity)this.tile(), dir, this.getCableType());
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this.tile());
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.addCable();
    }

    public void onWorldSeparate() {
        super.onWorldSeparate();
        this.removeCable();
    }

    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        if (!this.world().field_72995_K) {
            ArrayList<ILogicTile> adjacents = new ArrayList<ILogicTile>();
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                BlockCoords coords = new BlockCoords((TileEntity)this.tile());
                Object object = FMPHelper.checkObject((Object)BlockCoords.translateCoords((BlockCoords)coords, (ForgeDirection)dir).getTileEntity());
                if (object == null || !(object instanceof ILogicTile)) continue;
                adjacents.add((ILogicTile)object);
            }
            for (ILogicTile tile : adjacents) {
                if (tile instanceof IDataCable) {
                    IDataCable cable = (IDataCable)tile;
                    cable.removeCable();
                    cable.addCable();
                }
                if (!(tile instanceof IInfoEmitter)) continue;
                IInfoEmitter emitter = (IInfoEmitter)tile;
                emitter.removeConnections();
                emitter.addConnections();
            }
            this.removeCable();
            this.addCable();
        }
    }

    @Override
    public int registryID() {
        return this.registryID;
    }

    @Override
    public void setRegistryID(int id) {
        this.registryID = id;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    @Override
    public CableType getCableType() {
        return CableType.CHANNELLED_CABLE;
    }

    @Override
    public void addCable() {
        if (!this.world().field_72995_K) {
            LogisticsAPI.getCableHelper().addCable(this);
        }
    }

    @Override
    public void removeCable() {
        if (!this.world().field_72995_K) {
            LogisticsAPI.getCableHelper().removeCable(this);
        }
    }

    @Override
    public void refreshConnections() {
        if (!this.world().field_72995_K) {
            LogisticsAPI.getCableHelper().refreshConnections(this);
        }
    }

    public Block getBlock() {
        return BlockRegistry.channelledCable;
    }
}

