/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.helpers.RecipeHelper;
import sonar.logistics.utils.HammerRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.logistics.hammer")
public class HammerHandler {
    @ZenMethod
    public static void addRecipe(IIngredient input1, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input1, MineTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input1) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input1));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private Object input;
        private ItemStack output;

        public RemoveRecipeAction(Object input) {
            if (input instanceof IItemStack) {
                input = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input));
            }
            if (input instanceof IOreDictEntry) {
                input = new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1);
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed into a Forging Hammer Recipe, aborting!");
                this.output = null;
                input = null;
            }
            this.input = input;
            ItemStack dummyInput1 = null;
            if (input instanceof ItemStack) {
                dummyInput1 = (ItemStack)input;
            }
            if (input instanceof RecipeHelper.OreStack) {
                dummyInput1 = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input).oreString).get(0);
            }
            this.output = HammerRecipes.instance().getCraftingResult(new ItemStack[]{dummyInput1});
        }

        public void apply() {
            if (this.input == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.input == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().addRecipe(new Object[]{this.input, this.output});
        }

        public String describe() {
            return String.format("Removing Forging Hammer Recipe (%s = %s)", this.input, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private Object input;
        private ItemStack output;

        public AddRecipeAction(Object input1, ItemStack output) {
            if (input1 instanceof IItemStack) {
                input1 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input1));
            }
            if (input1 instanceof IOreDictEntry) {
                input1 = new RecipeHelper.OreStack(((IOreDictEntry)input1).getName(), 1);
            }
            if (input1 instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed into a Forging Hammer Recipe, aborting!");
                output = null;
                input1 = null;
            }
            this.input = input1;
            this.output = output;
        }

        public void apply() {
            if (this.input == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().addRecipe(new Object[]{this.input, this.output});
        }

        public void undo() {
            if (this.input == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public String describe() {
            return String.format("Adding Forging Hammer recipe (%s = %s)", this.input, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

