/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;

public class StoredStackInfo
extends ILogicInfo<StoredStackInfo> {
    public StoredItemStack stack;
    public String rend = "ITEMREND";
    public int cacheID = -1;

    public static StoredStackInfo createInfo(StoredItemStack stack, int cacheID) {
        StoredStackInfo info = new StoredStackInfo();
        info.stack = stack;
        info.cacheID = cacheID;
        return info;
    }

    @Override
    public String getName() {
        return "StoredStack";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.stack != null ? this.stack.item.func_82833_r() : this.rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public String getData() {
        return this.stack != null ? String.valueOf(this.stack.stored) : String.valueOf(0);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stack = StoredItemStack.readFromBuf((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        StoredItemStack.writeToBuf((ByteBuf)buf, (StoredItemStack)this.stack);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack = StoredItemStack.readFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        StoredItemStack.writeToNBT((NBTTagCompound)tag, (StoredItemStack)this.stack);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        if (this.stack != null && this.stack.item != null) {
            GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + (maxY - minY) / 2.0f), (float)0.01f);
            FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
            this.stack.item.field_77994_a = 1;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2884);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            double sizing = Math.round(Math.min(maxX - minX, maxY - minY));
            double itemScale = sizing >= 2.0 ? 2.5 + sizing - 1.0 : (type.isNormalSize() ? (double)0.8f : (double)1.4f);
            GL11.glTranslated((double)0.0, (double)this.getXTranslate(type.getScaling(), sizing), (double)((double)zOffset - 0.01));
            GL11.glScaled((double)itemScale, (double)itemScale, (double)itemScale);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.25f);
            RenderHelper.doRenderItem((ItemStack)this.stack.item, (World)tile.func_145831_w(), (boolean)false);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.242f);
            GL11.glScalef((float)0.025f, (float)0.025f, (float)0.025f);
            String s1 = FontHelper.formatStackSize((long)this.stack.stored);
            float scaleFactor = 0.5f;
            float inverseScaleFactor = 2.0f;
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            int X = (int)((7.0f - (float)rend.func_78256_a(s1) * 0.5f) * 2.0f);
            int Y = -1;
            GL11.glDisable((int)2896);
            rend.func_78276_b(s1, X, -1, 0xFFFFFF);
        }
    }

    public double getXTranslate(float scale, double sizing) {
        if (scale >= 120.0f) {
            return -0.02f;
        }
        return (double)-0.08f + (sizing - 1.0) * 0.17;
    }

    public StoredStackInfo instance() {
        return new StoredStackInfo();
    }

    @Override
    public void writeUpdate(StoredStackInfo currentInfo, NBTTagCompound tag) {
        if (!currentInfo.stack.equalStack(this.stack.item)) {
            NBTTagCompound writeTag = new NBTTagCompound();
            currentInfo.writeToNBT(writeTag);
            tag.func_74782_a("wT", (NBTBase)writeTag);
            this.stack = currentInfo.stack;
        } else if (currentInfo.stack.stored != this.stack.stored) {
            tag.func_74772_a("s", currentInfo.stack.stored);
            this.stack.stored = currentInfo.stack.stored;
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("wT")) {
            this.readFromNBT(tag.func_74775_l("wT"));
        } else if (tag.func_74764_b("s")) {
            this.stack.stored = tag.func_74763_f("s");
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(StoredStackInfo currentInfo) {
        if (this.cacheID != currentInfo.cacheID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (!currentInfo.stack.equals((Object)this.stack)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

