/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredEnergyStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.api.utils.IdentifiedCoords;

public class StoredEnergyInfo
extends ILogicInfo<StoredEnergyInfo> {
    private static final ResourceLocation progress = new ResourceLocation("PracticalLogistics:textures/model/progressBar.png");
    public StoredEnergyStack stack;
    public IdentifiedCoords coords;
    public String rend = "ITEMREND";

    public static StoredEnergyInfo createInfo(IdentifiedCoords coords, StoredEnergyStack stack) {
        StoredEnergyInfo info = new StoredEnergyInfo();
        info.stack = stack;
        info.coords = coords;
        return info;
    }

    @Override
    public String getName() {
        return "StoredEnergy";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.coords != null ? this.coords.block.func_82833_r() : this.rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public String getData() {
        return this.stack != null ? String.valueOf(this.stack.stored) : String.valueOf(0);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stack = StoredEnergyStack.readFromBuf((ByteBuf)buf);
        this.coords = IdentifiedCoords.readCoords(buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        StoredEnergyStack.writeToBuf((ByteBuf)buf, (StoredEnergyStack)this.stack);
        IdentifiedCoords.writeCoords(buf, this.coords);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack = StoredEnergyStack.readFromNBT((NBTTagCompound)tag);
        this.coords = IdentifiedCoords.readFromNBT(tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        StoredEnergyStack.writeToNBT((NBTTagCompound)tag, (StoredEnergyStack)this.stack);
        IdentifiedCoords.writeToNBT(tag, this.coords);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)((double)zOffset + 0.002));
        float width = (float)this.stack.stored * (maxX - minX) / (float)this.stack.capacity;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(progress);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.drawTexturedModalRect((double)minX, (double)minY, (double)maxY, (double)width, (double)(maxY - minY));
        GL11.glTranslated((double)0.0, (double)0.0, (double)((double)(-zOffset) - 0.002));
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + (maxY - minY) / 2.0f), (float)0.01f);
        int sizing = (int)Math.round(Math.min((double)(maxX - minX), (double)(maxY - minY) * 1.5));
        GL11.glTranslatef((float)0.0f, (float)((float)(type.isNormalSize() ? (double)-0.1f : (double)-0.31f + (double)(sizing - 1) * -0.04)), (float)zOffset);
        double itemScale = sizing >= 2 ? LogisticsAPI.getInfoRenderer().getScale(sizing) : 120.0;
        GL11.glScaled((double)(1.0 / itemScale), (double)(1.0 / itemScale), (double)(1.0 / itemScale));
        if (this.coords != null && this.coords.block != null) {
            String coordString = this.coords.block.func_82833_r();
            rend.func_78276_b(EnumChatFormatting.UNDERLINE + coordString, -rend.func_78256_a(coordString) / 2, -20, -1);
            String stored = "Stored: " + String.valueOf(this.stack.stored) + " " + this.stack.energyType.getStorageSuffix();
            String capacity = "Capacity: " + String.valueOf(this.stack.capacity) + " " + this.stack.energyType.getStorageSuffix();
            rend.func_78276_b(stored, -rend.func_78256_a(stored) / 2, -8, -1);
            rend.func_78276_b(capacity, -rend.func_78256_a(capacity) / 2, 4, -1);
            if (this.stack.hasInput) {
                String input = "Max Input: " + String.valueOf(this.stack.input) + " " + this.stack.energyType.getStorageSuffix();
                rend.func_78276_b(input, -rend.func_78256_a(input) / 2, 16, -1);
            }
            if (this.stack.hasOutput) {
                String output = "Max Output: " + String.valueOf(this.stack.output) + " " + this.stack.energyType.getStorageSuffix();
                rend.func_78276_b(output, -rend.func_78256_a(output) / 2, 28, -1);
            }
            if (this.stack.hasUsage) {
                String usage = "Usage: " + String.valueOf(this.stack.usage) + " " + this.stack.energyType.getUsageSuffix();
                rend.func_78276_b(usage, -rend.func_78256_a(usage) / 2, 28, -1);
            }
        }
    }

    public double getXTranslate(float scale, double sizing) {
        if (scale >= 120.0f) {
            return -0.02f;
        }
        return (double)-0.08f + (sizing - 1.0) * 0.17;
    }

    public StoredEnergyInfo instance() {
        return new StoredEnergyInfo();
    }

    @Override
    public void writeUpdate(StoredEnergyInfo currentInfo, NBTTagCompound tag) {
        if (currentInfo.stack.hasInput != this.stack.hasInput) {
            this.stack.hasInput = currentInfo.stack.hasInput;
            tag.func_74757_a("hI", this.stack.hasInput);
        }
        if (currentInfo.stack.hasOutput != this.stack.hasOutput) {
            this.stack.hasOutput = currentInfo.stack.hasOutput;
            tag.func_74757_a("hO", this.stack.hasOutput);
        }
        if (currentInfo.stack.hasStorage != this.stack.hasStorage) {
            this.stack.hasStorage = currentInfo.stack.hasStorage;
            tag.func_74757_a("hS", this.stack.hasStorage);
        }
        if (currentInfo.stack.hasUsage != this.stack.hasUsage) {
            this.stack.hasUsage = currentInfo.stack.hasUsage;
            tag.func_74757_a("hU", this.stack.hasUsage);
        }
        if (currentInfo.stack.capacity != this.stack.capacity) {
            this.stack.capacity = currentInfo.stack.capacity;
            tag.func_74772_a("c", this.stack.capacity);
        }
        if (currentInfo.stack.input != this.stack.input) {
            this.stack.input = currentInfo.stack.input;
            tag.func_74772_a("i", this.stack.input);
        }
        if (currentInfo.stack.output != this.stack.output) {
            this.stack.output = currentInfo.stack.output;
            tag.func_74772_a("o", this.stack.output);
        }
        if (currentInfo.stack.stored != this.stack.stored) {
            this.stack.stored = currentInfo.stack.stored;
            tag.func_74772_a("s", this.stack.stored);
        }
        if (currentInfo.stack.usage != this.stack.usage) {
            this.stack.usage = currentInfo.stack.usage;
            tag.func_74772_a("u", this.stack.usage);
        }
        if (!currentInfo.stack.energyType.getStorageSuffix().equals(this.stack.energyType.getStorageSuffix())) {
            this.stack.energyType = currentInfo.stack.energyType;
            tag.func_74778_a("energyType", this.stack.energyType.getStorageSuffix());
        }
        if (!currentInfo.coords.blockCoords.equals((Object)this.coords.blockCoords)) {
            this.coords.blockCoords = currentInfo.coords.blockCoords;
            BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)this.coords.blockCoords);
        }
        if (!ItemStack.func_77989_b((ItemStack)this.coords.block, (ItemStack)currentInfo.coords.block)) {
            this.coords.block = currentInfo.coords.block;
            this.coords.block.func_77955_b(tag);
        }
        if (!currentInfo.coords.coordString.equals(this.coords.coordString)) {
            this.coords.coordString = currentInfo.coords.coordString;
            tag.func_74778_a("suffix", this.coords.coordString);
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("hI")) {
            this.stack.hasInput = tag.func_74767_n("hI");
        }
        if (tag.func_74764_b("hO")) {
            this.stack.hasOutput = tag.func_74767_n("hO");
        }
        if (tag.func_74764_b("hS")) {
            this.stack.hasStorage = tag.func_74767_n("hS");
        }
        if (tag.func_74764_b("hU")) {
            this.stack.hasUsage = tag.func_74767_n("hU");
        }
        if (tag.func_74764_b("c")) {
            this.stack.capacity = tag.func_74763_f("c");
        }
        if (tag.func_74764_b("i")) {
            this.stack.input = tag.func_74763_f("i");
        }
        if (tag.func_74764_b("o")) {
            this.stack.output = tag.func_74763_f("o");
        }
        if (tag.func_74764_b("s")) {
            this.stack.stored = tag.func_74763_f("s");
        }
        if (tag.func_74764_b("u")) {
            this.stack.usage = tag.func_74763_f("u");
        }
        if (tag.func_74764_b("energyType")) {
            this.stack.energyType = SonarAPI.getRegistry().getEnergyType(tag.func_74779_i("energyType"));
        }
        if (tag.func_74764_b("x")) {
            this.coords.blockCoords = BlockCoords.readFromNBT((NBTTagCompound)tag);
        }
        if (tag.func_74764_b("id")) {
            this.coords.block = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        if (tag.func_74764_b("suffix")) {
            this.coords.coordString = tag.func_74779_i("suffix");
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(StoredEnergyInfo currentInfo) {
        if (!currentInfo.coords.equals(this.coords)) {
            return NBTHelper.SyncType.SAVE;
        }
        if (!currentInfo.stack.equals((Object)this.stack)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

