/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;

public class ProgressInfo
extends ILogicInfo<ProgressInfo> {
    private static final ResourceLocation progress = new ResourceLocation("PracticalLogistics:textures/model/progressBar.png");
    public String data;
    public long stored;
    public long max;
    public int fluidID = -1;
    public String rend = "Progress";

    public ProgressInfo() {
    }

    public ProgressInfo(long stored, long max, String data) {
        this.stored = stored;
        this.max = max;
        this.data = data;
    }

    public ProgressInfo(long stored, long max, String data, int fluidID) {
        this.stored = stored;
        this.max = max;
        this.data = data;
        this.fluidID = fluidID;
    }

    @Override
    public String getName() {
        return "ProgressBar";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.rend;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stored = buf.readLong();
        this.max = buf.readLong();
        this.fluidID = buf.readInt();
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeLong(this.stored);
        buf.writeLong(this.max);
        buf.writeInt(this.fluidID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stored = tag.func_74763_f("stored");
        this.max = tag.func_74763_f("max");
        this.fluidID = tag.func_74762_e("fluidID");
        this.data = tag.func_74779_i("data");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74772_a("stored", this.stored);
        tag.func_74772_a("max", this.max);
        tag.func_74768_a("fluidID", this.fluidID);
        tag.func_74778_a("data", this.data);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)((double)zOffset + 0.002));
        float width = (float)this.stored * (maxX - minX) / (float)this.max;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(progress);
        RenderHelper.drawTexturedModalRect((double)minX, (double)minY, (double)maxY, (double)width, (double)(maxY - minY));
        LogisticsAPI.getInfoRenderer().renderCenteredString(this.data, minX, minY, maxX, maxY, type);
    }

    public ProgressInfo instance() {
        return new ProgressInfo();
    }

    @Override
    public void writeUpdate(ProgressInfo currentInfo, NBTTagCompound tag) {
        if (currentInfo.max != this.max) {
            tag.func_74772_a("m", currentInfo.max);
            this.max = currentInfo.max;
        }
        if (currentInfo.stored != this.stored) {
            tag.func_74772_a("s", currentInfo.stored);
            this.stored = currentInfo.stored;
        }
        if (currentInfo.data != null && !currentInfo.data.equals(this.data)) {
            tag.func_74778_a("d", currentInfo.data);
            this.data = currentInfo.data;
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("m")) {
            this.max = tag.func_74763_f("m");
        }
        if (tag.func_74764_b("s")) {
            this.stored = tag.func_74763_f("s");
        }
        if (tag.func_74764_b("d")) {
            this.data = tag.func_74779_i("d");
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(ProgressInfo currentInfo) {
        if (currentInfo.max != this.max || currentInfo.stored != this.stored || !currentInfo.data.equals(this.data)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

