/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.info.LogicInfo;

public class ModidInfo
extends LogicInfo<ModidInfo> {
    public GameRegistry.UniqueIdentifier block = null;

    public ModidInfo() {
    }

    public ModidInfo(int providerID, int category, int subCategory, Object data, GameRegistry.UniqueIdentifier block) {
        super(providerID, category, subCategory, data);
        this.block = block;
        this.dataType = 1;
    }

    public ModidInfo(int providerID, String category, String subCategory, Object data, GameRegistry.UniqueIdentifier block) {
        super(providerID, category, subCategory, data);
        this.block = block;
        this.dataType = 1;
    }

    @Override
    public String getName() {
        return "Unique Identifier";
    }

    @Override
    public String getData() {
        return this.getName();
    }

    @Override
    public String getDisplayableData() {
        String modName;
        try {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(this.block.modId);
            modName = mod == null ? "Minecraft" : mod.getName();
        }
        catch (NullPointerException e) {
            modName = "";
        }
        return modName + this.suffix;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        super.writeToBuf(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block.modId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block.name);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        super.readFromBuf(buf);
        this.block = new GameRegistry.UniqueIdentifier(ByteBufUtils.readUTF8String((ByteBuf)buf) + ":" + ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound blockTag = new NBTTagCompound();
        blockTag.func_74778_a("modId", this.block.modId);
        blockTag.func_74778_a("name", this.block.name);
        tag.func_74782_a("block", (NBTBase)blockTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagCompound blockTag = tag.func_74775_l("block");
        this.block = new GameRegistry.UniqueIdentifier(blockTag.func_74779_i("modId") + ":" + blockTag.func_74779_i("name"));
    }

    @Override
    public void writeUpdate(LogicInfo currentInfo, NBTTagCompound tag) {
        super.writeUpdate(currentInfo, tag);
        if (currentInfo instanceof ModidInfo) {
            ModidInfo info = (ModidInfo)currentInfo;
            if (!info.block.modId.equals(this.block.modId) || !info.block.name.equals(this.block.name)) {
                NBTTagCompound blockTag = new NBTTagCompound();
                blockTag.func_74778_a("modId", this.block.modId);
                blockTag.func_74778_a("name", this.block.name);
                tag.func_74782_a("block", (NBTBase)blockTag);
            }
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        if (tag.func_74764_b("block")) {
            NBTTagCompound blockTag = tag.func_74775_l("block");
            this.block = new GameRegistry.UniqueIdentifier(blockTag.func_74779_i("modId") + ":" + blockTag.func_74779_i("name"));
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(ModidInfo currentInfo) {
        NBTHelper.SyncType matching = super.isMatchingData(currentInfo);
        if (matching == null) {
            return !this.block.modId.equals(currentInfo.block.modId) || !this.block.name.equals(currentInfo.block.name) ? NBTHelper.SyncType.SYNC : null;
        }
        return matching;
    }

    @Override
    public ModidInfo instance() {
        return new ModidInfo();
    }
}

