/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.LogisticsConfig;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.info.providers.tile.ManaProvider;
import sonar.logistics.info.types.ProgressInfo;

public class ManaInfo
extends ProgressInfo {
    private static final ResourceLocation progress = new ResourceLocation("PracticalLogistics:textures/model/progressBar.png");
    public int providerID = -1;

    public ManaInfo() {
        this.data = " ";
    }

    public ManaInfo(int providerID, long stored, long max) {
        this.stored = stored;
        this.max = max;
        this.providerID = providerID;
        this.data = " ";
    }

    @Override
    public String getName() {
        return "ManaBar";
    }

    @Override
    public int getProviderID() {
        return this.providerID;
    }

    @Override
    public String getCategory() {
        return new ManaProvider().getCategory(0);
    }

    @Override
    public String getSubCategory() {
        return "Mana";
    }

    @Override
    public String getData() {
        return String.valueOf(this.stored);
    }

    @Override
    public String getDisplayableData() {
        return LogisticsConfig.displayMana ? String.valueOf((long)((int)this.stored * 100) / this.max) + "%" : "-";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stored = buf.readLong();
        this.max = buf.readLong();
        this.providerID = buf.readInt();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeLong(this.stored);
        buf.writeLong(this.max);
        buf.writeInt(this.providerID);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stored = tag.func_74763_f("stored");
        this.max = tag.func_74763_f("max");
        this.providerID = tag.func_74762_e("ID");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74772_a("stored", this.stored);
        tag.func_74772_a("max", this.max);
        tag.func_74768_a("ID", (int)((byte)this.providerID));
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = (float)this.stored * (maxX - minX) / (float)this.max;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(progress);
        RenderHelper.drawTexturedModalRect((double)minX, (double)minY, (double)maxY, (double)width, (double)(maxY - minY));
        if (LogisticsConfig.displayMana) {
            LogisticsAPI.getInfoRenderer().renderCenteredString(this.getDisplayableData(), minX, minY, maxX, maxY, type);
        } else {
            LogisticsAPI.getInfoRenderer().renderCenteredString(this.getSubCategory() + this.getData(), minX, minY, maxX, maxY, type);
        }
    }

    @Override
    public ManaInfo instance() {
        return new ManaInfo();
    }

    @Override
    public NBTHelper.SyncType isMatchingData(ProgressInfo currentInfo) {
        if (!(currentInfo instanceof ManaInfo)) {
            return NBTHelper.SyncType.SAVE;
        }
        if (this.providerID != ((ManaInfo)currentInfo).providerID) {
            return NBTHelper.SyncType.SYNC;
        }
        return super.isMatchingData(currentInfo);
    }
}

