/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.helpers.ItemHelper;

public class InventoryInfo
extends ILogicInfo<InventoryInfo> {
    public ItemWrapper.StorageItems stacks = ItemWrapper.StorageItems.EMPTY.copy();
    public boolean lastSync = false;
    public int cacheID = -1;
    public int sort = -1;
    public int order = -1;
    public String rend = "ITEMINV";

    public static InventoryInfo createInfo(ItemWrapper.StorageItems stacks, int cacheID, int sort, int order) {
        InventoryInfo info = new InventoryInfo();
        info.stacks = stacks.copy();
        info.cacheID = cacheID;
        info.sort = sort;
        info.order = order;
        return info;
    }

    @Override
    public String getName() {
        return "InventoryInfo";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public String getData() {
        return "Inventory";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.sort = buf.readInt();
        this.order = buf.readInt();
        this.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.sort);
        buf.writeInt(this.order);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.sort = tag.func_74762_e("sort");
        this.order = tag.func_74762_e("order");
        ItemHelper.readStorageToNBT(tag, this.stacks.items, NBTHelper.SyncType.SYNC);
        ItemHelper.sortItemList(this.stacks.items, ItemWrapper.SortingDirection.values()[this.order], ItemWrapper.SortingType.values()[this.sort]);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("sort", this.sort);
        tag.func_74768_a("order", this.order);
        this.lastSync = false;
        ItemHelper.writeStorageToNBT(tag, this.lastSync, this.stacks, NBTHelper.SyncType.SYNC);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        if (this.stacks != null) {
            int xSlots = Math.round(maxX - minX) * 2;
            int ySlots = Math.round(maxY - minY) * 2;
            if (type.isNormalSize()) {
                xSlots = 2;
                ySlots = 1;
            }
            int currentSlot = 0;
            if (this.stacks != null) {
                List currentStacks = (List)this.stacks.items.clone();
                GL11.glTranslatef((float)(minX + 0.18f), (float)(minY + 0.18f), (float)0.01f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.19f);
                GL11.glTranslated((double)0.0, (double)0.07f, (double)((double)zOffset - 0.01));
                float spacing = 0.665f;
                GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                for (StoredItemStack stack : currentStacks) {
                    if (stack != null && currentSlot < xSlots * ySlots) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        int xLevel = (int)((double)currentSlot - Math.floor(currentSlot / xSlots) * (double)xSlots);
                        int yLevel = (int)Math.floor(currentSlot / xSlots);
                        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
                        if (stack.item != null) {
                            GL11.glPushMatrix();
                            stack.item.field_77994_a = 1;
                            GL11.glDisable((int)32826);
                            GL11.glEnable((int)2884);
                            tess.func_78386_a(1.0f, 1.0f, 1.0f);
                            double sizing = Math.round(Math.min(maxX - minX, maxY - minY));
                            double itemScale = sizing >= 2.0 ? 2.5 + sizing - 1.0 : (type.isNormalSize() ? (double)0.8f : (double)1.4f);
                            GL11.glTranslatef((float)((float)xLevel * spacing), (float)((float)yLevel * spacing), (float)0.0f);
                            RenderHelper.doRenderItem((ItemStack)stack.item, (World)tile.func_145831_w(), (boolean)false);
                            GL11.glDisable((int)2884);
                            GL11.glEnable((int)32826);
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.242f);
                            GL11.glScalef((float)0.025f, (float)0.025f, (float)0.025f);
                            String s1 = FontHelper.formatStackSize((long)stack.stored);
                            float scaleFactor = 0.5f;
                            float inverseScaleFactor = 2.0f;
                            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                            int X = (int)((7.0f - (float)rend.func_78256_a(s1) * 0.5f) * 2.0f);
                            int Y = -1;
                            GL11.glDisable((int)2896);
                            rend.func_78276_b(s1, X, -1, 0xFFFFFF);
                            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
                            GL11.glScaled((double)40.0, (double)40.0, (double)40.0);
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.242f);
                            GL11.glTranslatef((float)((float)(-xLevel) * spacing), (float)((float)(-yLevel) * spacing), (float)0.0f);
                            GL11.glPopMatrix();
                        }
                    }
                    ++currentSlot;
                }
            }
        }
    }

    public double getXTranslate(float scale, double sizing) {
        if (scale >= 120.0f) {
            return 0.07f;
        }
        return (double)0.13f + (sizing - 1.0) * 0.17;
    }

    public InventoryInfo instance() {
        return new InventoryInfo();
    }

    @Override
    public void writeUpdate(InventoryInfo currentInfo, NBTTagCompound tag) {
        if (currentInfo.sort != this.sort) {
            tag.func_74768_a("sort", currentInfo.sort);
            this.sort = currentInfo.sort;
        }
        if (currentInfo.order != this.order) {
            tag.func_74768_a("order", currentInfo.order);
            this.order = currentInfo.order;
        }
        this.lastSync = ItemHelper.writeStorageToNBT(tag, this.lastSync, currentInfo.stacks, NBTHelper.SyncType.SPECIAL);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("sort")) {
            this.sort = tag.func_74762_e("sort");
        }
        if (tag.func_74764_b("order")) {
            this.order = tag.func_74762_e("order");
        }
        ItemHelper.readStorageToNBT(tag, this.stacks.items, NBTHelper.SyncType.SPECIAL);
        ItemHelper.sortItemList(this.stacks.items, ItemWrapper.SortingDirection.values()[this.order], ItemWrapper.SortingType.values()[this.sort]);
    }

    @Override
    public NBTHelper.SyncType isMatchingData(InventoryInfo currentInfo) {
        if (this.cacheID != currentInfo.cacheID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (this.sort != currentInfo.sort || this.order != currentInfo.order || !currentInfo.stacks.items.equals(this.stacks.items)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

