/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import sonar.core.api.StoredFluidStack;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;

public class FluidStackInfo
extends ILogicInfo<FluidStackInfo> {
    public StoredFluidStack stack;
    public static String rend = "FLUID";
    public int cacheID = -1;

    public static FluidStackInfo createInfo(StoredFluidStack stack, int cacheID) {
        FluidStackInfo info = new FluidStackInfo();
        info.stack = stack;
        info.cacheID = cacheID;
        return info;
    }

    @Override
    public String getName() {
        return "FluidStack";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return rend;
    }

    @Override
    public String getSubCategory() {
        return this.stack != null ? this.stack.fluid.getFluid().getLocalizedName(this.stack.fluid) : rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData() + " mB";
    }

    @Override
    public String getData() {
        return this.stack != null && this.stack.capacity != 0L ? String.valueOf(this.stack.stored) : String.valueOf(0);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stack = StoredFluidStack.readFromBuf((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        StoredFluidStack.writeToBuf((ByteBuf)buf, (StoredFluidStack)this.stack);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack = StoredFluidStack.readFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        StoredFluidStack.writeToNBT((NBTTagCompound)tag, (StoredFluidStack)this.stack);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = (float)this.stack.stored * (maxX - minX) / (float)this.stack.capacity;
        IIcon icon = this.stack.fluid.getFluid().getIcon();
        if (icon != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            tess.func_78382_b();
            double divide = Math.max(0.5 + (double)(maxX - minX), 0.5 + (double)(maxY - minY));
            double widthnew = (double)icon.func_94209_e() + (double)(width * (icon.func_94212_f() - icon.func_94209_e())) / divide;
            double heightnew = (double)icon.func_94206_g() + (double)((maxY - minY) * (icon.func_94210_h() - icon.func_94206_g())) / divide;
            double height = maxY / 2.0f;
            tess.func_78374_a((double)(minX + 0.0f), height, 0.0, (double)icon.func_94209_e(), heightnew);
            tess.func_78374_a((double)(minX + width), height, 0.0, widthnew, heightnew);
            tess.func_78374_a((double)(minX + width), (double)minY, 0.0, widthnew, (double)icon.func_94206_g());
            tess.func_78374_a((double)(minX + 0.0f), (double)minY, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tess.func_78381_a();
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-zOffset));
        super.renderInfo(tess, tile, minX, minY, maxX, maxY, zOffset, type);
    }

    public FluidStackInfo instance() {
        return new FluidStackInfo();
    }

    @Override
    public void writeUpdate(FluidStackInfo currentInfo, NBTTagCompound tag) {
        if (!currentInfo.stack.equalStack(this.stack.fluid)) {
            NBTTagCompound writeTag = new NBTTagCompound();
            currentInfo.writeToNBT(writeTag);
            tag.func_74782_a("wT", (NBTBase)writeTag);
            this.stack = currentInfo.stack;
        } else {
            if (currentInfo.stack.stored != this.stack.stored) {
                this.stack.stored = currentInfo.stack.stored;
                tag.func_74772_a("s", this.stack.stored);
            }
            if (currentInfo.stack.capacity != this.stack.capacity) {
                tag.func_74772_a("c", currentInfo.stack.capacity);
                this.stack.capacity = currentInfo.stack.capacity;
            }
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("wT")) {
            this.readFromNBT(tag.func_74775_l("wT"));
        } else {
            if (tag.func_74764_b("s")) {
                this.stack.stored = tag.func_74763_f("s");
            }
            if (tag.func_74764_b("c")) {
                this.stack.capacity = tag.func_74763_f("c");
            }
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(FluidStackInfo currentInfo) {
        if (this.cacheID != currentInfo.cacheID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (!currentInfo.stack.equals((Object)this.stack)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

