/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import sonar.core.api.StoredFluidStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.helpers.FluidHelper;
import sonar.logistics.info.types.FluidStackInfo;

public class FluidInventoryInfo
extends ILogicInfo<FluidInventoryInfo> {
    public FluidWrapper.StorageFluids stacks = FluidWrapper.StorageFluids.EMPTY.copy();
    public boolean lastSync = false;
    public int cacheID = -1;
    public int sort = -1;
    public int order = -1;
    public static String rend = "FLUIDS";

    public static FluidInventoryInfo createInfo(FluidWrapper.StorageFluids stacks, int cacheID, int sort, int order) {
        FluidInventoryInfo info = new FluidInventoryInfo();
        info.stacks = stacks.copy();
        info.cacheID = cacheID;
        info.sort = sort;
        info.order = order;
        return info;
    }

    @Override
    public String getName() {
        return "FluidInventoryInfo";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return rend;
    }

    @Override
    public String getSubCategory() {
        return rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public String getData() {
        return "Inventory";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.sort = buf.readInt();
        this.order = buf.readInt();
        this.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.sort);
        buf.writeInt(this.order);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.sort = tag.func_74762_e("sort");
        this.order = tag.func_74762_e("order");
        FluidHelper.readStorageToNBT(tag, this.stacks.fluids, NBTHelper.SyncType.SYNC);
        FluidHelper.sortFluidList(this.stacks.fluids, ItemWrapper.SortingDirection.values()[this.order], ItemWrapper.SortingType.values()[this.sort]);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("sort", this.sort);
        tag.func_74768_a("order", this.order);
        this.lastSync = false;
        FluidHelper.writeStorageToNBT(tag, this.lastSync, this.stacks, NBTHelper.SyncType.SYNC);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        if (this.stacks.fluids != null) {
            int xSlots = Math.round(maxX - minX);
            int ySlots = Math.round(maxY - minY);
            if (type.isNormalSize()) {
                if (this.stacks.fluids != null && !this.stacks.fluids.isEmpty() && this.stacks.fluids.get(0) != null) {
                    FluidStackInfo.createInfo(this.stacks.fluids.get(0), this.cacheID).renderInfo(tess, tile, minX, minY, maxX, maxY, zOffset, type);
                }
            } else {
                float fluidMaxX = 0.875f;
                float fluidMinX = 0.0f;
                float fluidMaxY = 0.875f;
                float fluidMinY = 0.0f;
                int currentSlot = 0;
                if (this.stacks != null) {
                    List currentStacks = (List)this.stacks.fluids.clone();
                    GL11.glTranslatef((float)minX, (float)minY, (float)0.01f);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)((double)zOffset - 0.01));
                    float spacing = 1.0f;
                    for (StoredFluidStack stack : currentStacks) {
                        if (stack != null && currentSlot < xSlots * ySlots) {
                            int xLevel = (int)((double)currentSlot - Math.floor(currentSlot / xSlots) * (double)xSlots);
                            int yLevel = (int)Math.floor(currentSlot / xSlots);
                            float width = (float)stack.stored * (fluidMaxX - fluidMinX) / (float)stack.capacity;
                            IIcon icon = stack.fluid.getFluid().getIcon();
                            if (icon != null) {
                                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                                GL11.glTranslatef((float)((float)xLevel * spacing), (float)((float)yLevel * spacing), (float)0.0f);
                                tess.func_78382_b();
                                double divide = Math.max(0.5 + (double)(fluidMaxX - fluidMinX), 0.5 + (double)(fluidMaxY - fluidMinY));
                                double widthnew = (double)icon.func_94209_e() + (double)(width * (icon.func_94212_f() - icon.func_94209_e())) / divide;
                                double heightnew = (double)icon.func_94206_g() + (double)((fluidMaxY - fluidMinY) * (icon.func_94210_h() - icon.func_94206_g())) / divide;
                                double height = fluidMaxY;
                                tess.func_78374_a((double)(fluidMinX + 0.0f), height, 0.0, (double)icon.func_94209_e(), heightnew);
                                tess.func_78374_a((double)(fluidMinX + width), height, 0.0, widthnew, heightnew);
                                tess.func_78374_a((double)(fluidMinX + width), (double)fluidMinY, 0.0, widthnew, (double)icon.func_94206_g());
                                tess.func_78374_a((double)(fluidMinX + 0.0f), (double)fluidMinY, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                                tess.func_78381_a();
                                GL11.glTranslatef((float)((float)(-xLevel) * spacing), (float)((float)(-yLevel) * spacing), (float)0.0f);
                            }
                            FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
                            String category = stack != null ? stack.fluid.getFluid().getLocalizedName(stack.fluid) : FluidInventoryInfo.rend;
                            String data = FontHelper.formatFluidSize((long)stack.stored);
                            float itemScale = 120.0f;
                            GL11.glPushMatrix();
                            GL11.glTranslatef((float)((float)xLevel * spacing), (float)((float)yLevel * spacing), (float)0.0f);
                            GL11.glTranslatef((float)(fluidMinX + (fluidMaxX - fluidMinX) / 2.0f), (float)(fluidMinY + (fluidMaxY - fluidMinY) / 2.0f), (float)0.01f);
                            GL11.glScaled((double)(1.0f / itemScale), (double)(1.0f / itemScale), (double)(1.0f / itemScale));
                            rend.func_78276_b(category, -rend.func_78256_a(category) / 2, -8, -1);
                            rend.func_78276_b(data, -rend.func_78256_a(data) / 2, 4, -1);
                            GL11.glScaled((double)itemScale, (double)itemScale, (double)itemScale);
                            GL11.glTranslatef((float)((float)(-xLevel) * spacing), (float)((float)(-yLevel) * spacing), (float)0.0f);
                            GL11.glPopMatrix();
                        }
                        ++currentSlot;
                    }
                }
            }
        }
    }

    public double getXTranslate(float scale, double sizing) {
        if (scale >= 120.0f) {
            return 0.07f;
        }
        return (double)0.13f + (sizing - 1.0) * 0.17;
    }

    public FluidInventoryInfo instance() {
        return new FluidInventoryInfo();
    }

    @Override
    public void writeUpdate(FluidInventoryInfo currentInfo, NBTTagCompound tag) {
        if (currentInfo.sort != this.sort) {
            tag.func_74768_a("sort", currentInfo.sort);
            this.sort = currentInfo.sort;
        }
        if (currentInfo.order != this.order) {
            tag.func_74768_a("order", currentInfo.order);
            this.order = currentInfo.order;
        }
        this.lastSync = FluidHelper.writeStorageToNBT(tag, this.lastSync, currentInfo.stacks, NBTHelper.SyncType.SPECIAL);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("sort")) {
            this.sort = tag.func_74762_e("sort");
        }
        if (tag.func_74764_b("order")) {
            this.order = tag.func_74762_e("order");
        }
        FluidHelper.readStorageToNBT(tag, this.stacks.fluids, NBTHelper.SyncType.SPECIAL);
        FluidHelper.sortFluidList(this.stacks.fluids, ItemWrapper.SortingDirection.values()[this.order], ItemWrapper.SortingType.values()[this.sort]);
    }

    @Override
    public NBTHelper.SyncType isMatchingData(FluidInventoryInfo currentInfo) {
        if (this.cacheID != currentInfo.cacheID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (this.sort != currentInfo.sort || this.order != currentInfo.order || !currentInfo.stacks.fluids.equals(this.stacks.fluids)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

