/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.info.LogicInfo;

public class BlockNameInfo
extends LogicInfo<BlockNameInfo> {
    public ItemStack block = null;

    public BlockNameInfo() {
    }

    public BlockNameInfo(int providerID, int category, int subCategory, Object data, ItemStack block) {
        super(providerID, category, subCategory, data);
        this.block = block;
        this.dataType = 1;
    }

    public BlockNameInfo(int providerID, String category, String subCategory, Object data, ItemStack block) {
        super(providerID, category, subCategory, data);
        this.block = block;
        this.dataType = 1;
    }

    @Override
    public String getName() {
        return "Block Name";
    }

    @Override
    public String getData() {
        return this.block.func_82833_r();
    }

    @Override
    public String getDisplayableData() {
        return this.block.func_82833_r() + this.suffix;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        super.writeToBuf(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        super.readFromBuf(buf);
        this.block = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound blockTag = new NBTTagCompound();
        this.block.func_77955_b(blockTag);
        tag.func_74782_a("block", (NBTBase)blockTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.block = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("block"));
    }

    @Override
    public void writeUpdate(LogicInfo currentInfo, NBTTagCompound tag) {
        super.writeUpdate(currentInfo, tag);
        if (currentInfo instanceof BlockNameInfo) {
            BlockNameInfo info = (BlockNameInfo)currentInfo;
            if (!ItemStack.func_77989_b((ItemStack)info.block, (ItemStack)this.block) || !ItemStack.func_77970_a((ItemStack)info.block, (ItemStack)this.block)) {
                this.block = info.block;
                NBTTagCompound blockTag = new NBTTagCompound();
                this.block.func_77955_b(blockTag);
                tag.func_74782_a("block", (NBTBase)blockTag);
            }
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        if (tag.func_74764_b("block")) {
            this.block = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("block"));
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(BlockNameInfo currentInfo) {
        if (currentInfo.getProviderID() != this.providerID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (!(currentInfo.dataType == this.dataType && currentInfo.category.equals(this.category) && currentInfo.subCategory.equals(this.subCategory) && currentInfo.suffix.equals(this.suffix) && currentInfo.catID == this.catID && currentInfo.subCatID == this.subCatID)) {
            return NBTHelper.SyncType.SYNC;
        }
        return super.isMatchingData(currentInfo);
    }
}

