/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.info.ILogicInfo;

public class BlockCoordsInfo
extends ILogicInfo<BlockCoordsInfo> {
    public String name;
    public BlockCoords coords;

    public static ILogicInfo createInfo(String name, BlockCoords coords) {
        BlockCoordsInfo info = new BlockCoordsInfo();
        info.name = name;
        info.coords = coords;
        return info;
    }

    @Override
    public String getName() {
        return "Coords";
    }

    @Override
    public int getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.name;
    }

    @Override
    public String getSubCategory() {
        return this.name;
    }

    @Override
    public String getData() {
        return this.coords.toString();
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.coords = BlockCoords.readFromBuf((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        BlockCoords.writeToBuf((ByteBuf)buf, (BlockCoords)this.coords);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.coords = BlockCoords.readFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)this.coords);
    }

    public BlockCoordsInfo instance() {
        return new BlockCoordsInfo();
    }

    @Override
    public void writeUpdate(BlockCoordsInfo currentInfo, NBTTagCompound tag) {
        if (!currentInfo.name.equals(this.name)) {
            this.name = currentInfo.name;
            tag.func_74778_a("n", this.name);
        }
        if (!currentInfo.coords.equals((Object)this.coords)) {
            this.coords = currentInfo.coords;
            NBTTagCompound coordTag = new NBTTagCompound();
            BlockCoords.writeToNBT((NBTTagCompound)coordTag, (BlockCoords)this.coords);
            tag.func_74782_a("cT", (NBTBase)coordTag);
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("n")) {
            this.name = tag.func_74779_i("n");
        }
        if (tag.func_74764_b("cT")) {
            this.coords = BlockCoords.readFromNBT((NBTTagCompound)tag.func_74775_l("cT"));
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(BlockCoordsInfo currentInfo) {
        if (!currentInfo.name.equals(this.name) || !currentInfo.coords.equals((Object)this.coords)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

