/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;
import sonar.logistics.info.types.FluidInfo;

public class TankProvider
extends TileProvider {
    public static String name = "Tank-Helper";
    public String[] categories = new String[]{"TANK"};
    public String[] subcategories = new String[]{"Capacity", "Stored", "Fluid Type"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IFluidTank || target instanceof IFluidHandler);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IFluidHandler handler;
        FluidTankInfo[] info;
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IFluidTank) {
            IFluidTank tank = (IFluidTank)target;
            int capacity = tank.getCapacity();
            int currentStored = tank.getFluidAmount();
            infoList.add(new LogicInfo(id, 0, 0, (Object)tank.getCapacity()).addSuffix("MB"));
            infoList.add(new LogicInfo(id, 0, 1, (Object)tank.getFluidAmount()).addSuffix("MB"));
            if (tank.getFluid() != null) {
                FluidStack fluid = tank.getFluid();
                infoList.add(new LogicInfo(id, 0, 2, (Object)fluid.getLocalizedName()));
            }
        } else if (target instanceof IFluidHandler && (info = (handler = (IFluidHandler)target).getTankInfo(dir)) != null) {
            int tankNumber = 0;
            for (FluidTankInfo tankInfo : info) {
                String prefix = "ID " + ++tankNumber + ": ";
                if (info.length == 1) {
                    prefix = "";
                }
                if (tankInfo.fluid != null) {
                    int fluidID = tankInfo.fluid.getFluidID();
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Capacity", tankInfo.capacity, fluidID).addSuffix("MB"));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Stored", tankInfo.fluid.amount, fluidID).addSuffix("MB"));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Fluid ID", tankInfo.fluid.getFluidID(), fluidID));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Fluid Name", tankInfo.fluid.getLocalizedName(), fluidID));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Temperature", tankInfo.fluid.getFluid().getTemperature(), fluidID));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Density", tankInfo.fluid.getFluid().getDensity(), fluidID));
                    infoList.add(new FluidInfo(id, "TANK", prefix + "Viscosity", tankInfo.fluid.getFluid().getViscosity(), fluidID));
                    continue;
                }
                infoList.add(new FluidInfo(id, "TANK", prefix + "Capacity", tankInfo.capacity, -1).addSuffix("MB"));
                infoList.add(new FluidInfo(id, "TANK", prefix + "Stored", 0, -1).addSuffix("MB"));
                infoList.add(new FluidInfo(id, "TANK", prefix + "Fluid Name", "NO FLUID", -1));
            }
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }
}

