/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import Reika.RotaryCraft.API.Interfaces.TemperatureTile;
import Reika.RotaryCraft.API.Interfaces.TensionStorage;
import Reika.RotaryCraft.API.Power.PowerAcceptor;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.PowerTracker;
import Reika.RotaryCraft.API.Power.ShaftMachine;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class RotaryCraftProvider
extends TileProvider {
    public static String name = "Rotary-Craft Provider";
    public String[] categories = new String[]{"ENERGY RF"};
    public String[] subcategories = new String[]{"Connects: ", "Current", "Max Energy", "Stored", "Max Stored"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof TemperatureTile || target instanceof ShaftMachine || target instanceof PowerAcceptor || target instanceof PowerGenerator || target instanceof PowerTracker || target instanceof TensionStorage);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        TemperatureTile tile;
        int id = this.getID();
        TileEntity handler = world.func_147438_o(x, y, z);
        if (handler instanceof TemperatureTile) {
            tile = (TemperatureTile)handler;
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getTemperature()).addSuffix("degrees"));
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getMaxTemperature()).addSuffix("degrees"));
        }
        if (handler instanceof ShaftMachine) {
            tile = (ShaftMachine)handler;
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getOmega()).addSuffix("rad/s"));
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getTorque()).addSuffix("Nm"));
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getPower()).addSuffix("watts"));
        }
        if (handler instanceof PowerAcceptor) {
            tile = (PowerAcceptor)handler;
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.isReceiving()));
        }
        if (handler instanceof PowerGenerator) {
            tile = (PowerGenerator)handler;
            infoList.add(new LogicInfo(id, 0, 0, (Object)tile.getCurrentPower()).addSuffix("watts"));
        }
        if (handler instanceof TensionStorage) {
            infoList.add(new LogicInfo(id, 0, 0, (Object)handler.func_145832_p()).addSuffix("watts"));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"RotaryCraft");
    }
}

