/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cpw.mods.fml.common.Loader;
import java.util.List;
import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class RFEnergyProvider
extends TileProvider {
    public static String name = "Redstone-Flux";
    public String[] categories = new String[]{"ENERGY RF"};
    public String[] subcategories = new String[]{"Connects: ", "Current", "Max Energy", "Stored", "Max Stored"};

    public String getName() {
        return "Redstone-Flux";
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && target instanceof IEnergyConnection && (!Loader.isModLoaded((String)"Mekanism") || !(target instanceof IStrictEnergyStorage));
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyConnection info;
        int id = this.getID();
        TileEntity handler = world.func_147438_o(x, y, z);
        boolean displayEnergy = true;
        if (Loader.isModLoaded((String)"Mekanism")) {
            boolean bl = displayEnergy = !(handler instanceof IStrictEnergyStorage);
        }
        if (handler instanceof IEnergyConnection) {
            info = (IEnergyConnection)handler;
            boolean canConnect = info.canConnectEnergy(dir);
            infoList.add(new LogicInfo(id, 0, 0, (Object)("" + canConnect)));
        }
        if (handler instanceof IEnergyStorage) {
            info = (IEnergyStorage)handler;
            infoList.add(new LogicInfo(id, 0, 1, (Object)info.getEnergyStored()).addSuffix("RF"));
            infoList.add(new LogicInfo(id, 0, 2, (Object)info.getMaxEnergyStored()).addSuffix("RF"));
        } else if (handler instanceof IEnergyHandler) {
            info = (IEnergyHandler)handler;
            int energyStored = info.getEnergyStored(dir);
            int maxStored = info.getMaxEnergyStored(dir);
            if (maxStored != 0) {
                infoList.add(new LogicInfo(id, 0, 3, (Object)energyStored).addSuffix("RF"));
                infoList.add(new LogicInfo(id, 0, 4, (Object)maxStored).addSuffix("RF"));
            }
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }
}

