/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mekanism.api.IEvaporationSolar;
import mekanism.api.IHeatTransfer;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.lasers.ILaserReceptor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class MekanismGeneralProvider
extends TileProvider {
    public static String name = "Mekanism-General";
    public String[] categories = new String[]{"Mekanism General", "Mekanism Energy"};
    public String[] subcategories = new String[]{"Temperature", "Can See Sun", "Can Laser Dig", "Stored", "Max Stored", "Can Connect"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IHeatTransfer || target instanceof IEvaporationSolar || target instanceof ILaserReceptor || target instanceof IStrictEnergyStorage);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IHeatTransfer block;
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IHeatTransfer) {
            block = (IHeatTransfer)target;
            infoList.add(new LogicInfo(id, 0, 0, (Object)((int)block.getTemp())).addSuffix("degrees"));
        }
        if (target instanceof IEvaporationSolar) {
            block = (IEvaporationSolar)target;
            infoList.add(new LogicInfo(id, 0, 1, (Object)block.seesSun()));
        }
        if (target instanceof ILaserReceptor) {
            block = (ILaserReceptor)target;
            infoList.add(new LogicInfo(id, 0, 2, (Object)block.canLasersDig()));
        }
        if (target instanceof IStrictEnergyStorage) {
            block = (IStrictEnergyStorage)target;
            infoList.add(new LogicInfo(id, 1, 3, (Object)((long)block.getEnergy())).addSuffix("J"));
            infoList.add(new LogicInfo(id, 1, 4, (Object)((long)block.getMaxEnergy())).addSuffix("J"));
        }
        if (target instanceof IStrictEnergyAcceptor) {
            block = (IStrictEnergyAcceptor)target;
            infoList.add(new LogicInfo(id, 1, 5, (Object)block.canReceiveEnergy(dir)));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"Mekanism");
    }
}

