/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class IC2ReactorProvider
extends TileProvider {
    public static String name = "IC2-Reactor";
    public String[] categories = new String[]{"IC2 Reactor"};
    public String[] subcategories = new String[]{"Is Active", "Heat", "Max Heat", "Energy Output", "Fluid Cooled"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IReactor || target instanceof IReactorChamber);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        IReactor reactor = null;
        if (target instanceof IReactorChamber) {
            IReactorChamber chamber = (IReactorChamber)target;
            reactor = chamber.getReactor();
        }
        if (target instanceof IReactor) {
            reactor = (IReactor)target;
        }
        if (reactor != null) {
            infoList.add(new LogicInfo(id, 0, 0, (Object)reactor.produceEnergy()));
            infoList.add(new LogicInfo(id, 0, 1, (Object)reactor.getHeat()));
            infoList.add(new LogicInfo(id, 0, 2, (Object)reactor.getMaxHeat()));
            infoList.add(new LogicInfo(id, 0, 3, (Object)((int)reactor.getReactorEUEnergyOutput())));
            infoList.add(new LogicInfo(id, 0, 4, (Object)reactor.isFluidCooled()));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"IC2");
    }
}

