/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import java.util.List;
import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class EUEnergyProvider
extends TileProvider {
    public static String name = "EU-Provider";
    public String[] categories = new String[]{"ENERGY EU"};
    public String[] subcategories = new String[]{"Sink Tier", "Demanded Energy", "Source Tier", "Offered Energy", "Stored", "Capacity", "Output"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return !(target == null || !(target instanceof IEnergyTile) && !(target instanceof IEnergyStorage) || Loader.isModLoaded((String)"Mekanism") && target instanceof IStrictEnergyStorage);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyStorage energy;
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IEnergyStorage) {
            energy = (IEnergyStorage)target;
            infoList.add(new LogicInfo(id, 0, 4, (Object)energy.getStored()).addSuffix("EU"));
            infoList.add(new LogicInfo(id, 0, 5, (Object)energy.getCapacity()).addSuffix("EU"));
            infoList.add(new LogicInfo(id, 0, 6, (Object)energy.getOutput()).addSuffix("EU/t"));
        }
        if (target instanceof IEnergySink) {
            energy = (IEnergySink)target;
            infoList.add(new LogicInfo(id, 0, 0, (Object)energy.getSinkTier()));
            infoList.add(new LogicInfo(id, 0, 1, (Object)((long)energy.getDemandedEnergy())).addSuffix("EU"));
        }
        if (target instanceof IEnergySource) {
            energy = (IEnergySource)target;
            infoList.add(new LogicInfo(id, 0, 2, (Object)energy.getSourceTier()));
            infoList.add(new LogicInfo(id, 0, 3, (Object)((long)energy.getOfferedEnergy())).addSuffix("EU"));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"IC2");
    }
}

