/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.api.machines.IFlawlessGreenhouse;
import sonar.calculator.mod.api.machines.IGreenhouse;
import sonar.calculator.mod.api.machines.IProcessMachine;
import sonar.calculator.mod.api.nutrition.IHealthProcessor;
import sonar.calculator.mod.api.nutrition.IHungerProcessor;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class CalculatorMachineProvider
extends TileProvider {
    public static String name = "Calculator-Machine-Provider";
    public String[] categories = new String[]{"Calculator", "Calculator Greenhouse", "Calculator Machine"};
    public String[] subcategories = new String[]{"Health Points", "Hunger Points", "Carbon Level", "Oxygen Level", "Max Gas Level", "Plants Grown", "Plants Harvested", "Current Process Time", "Process Time", "Energy Usage"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IHealthProcessor || target instanceof IHungerProcessor || target instanceof IGreenhouse || target instanceof IProcessMachine);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null) {
            IGreenhouse greenhouse;
            if (target instanceof IHealthProcessor) {
                IHealthProcessor health = (IHealthProcessor)target;
                infoList.add(new LogicInfo(id, 0, 0, (Object)health.getHealthPoints()));
            }
            if (target instanceof IHungerProcessor) {
                IHungerProcessor hunger = (IHungerProcessor)target;
                infoList.add(new LogicInfo(id, 0, 1, (Object)hunger.getHungerPoints()));
            }
            if (target instanceof IGreenhouse) {
                greenhouse = (IGreenhouse)target;
                infoList.add(new LogicInfo(id, 1, 2, (Object)greenhouse.getCarbon()));
                infoList.add(new LogicInfo(id, 1, 3, (Object)greenhouse.getOxygen()));
                infoList.add(new LogicInfo(id, 1, 4, (Object)greenhouse.maxGasLevel()));
                if (target instanceof IFlawlessGreenhouse) {
                    IFlawlessGreenhouse flawless = (IFlawlessGreenhouse)target;
                    infoList.add(new LogicInfo(id, 1, 5, (Object)flawless.getPlantsGrown()));
                    infoList.add(new LogicInfo(id, 1, 6, (Object)flawless.getPlantsHarvested()));
                }
            }
            if (target instanceof IProcessMachine) {
                greenhouse = (IProcessMachine)target;
                infoList.add(new LogicInfo(id, 2, 7, (Object)greenhouse.getCurrentProcessTime()).addSuffix("ticks"));
                infoList.add(new LogicInfo(id, 2, 8, (Object)greenhouse.getProcessTime()).addSuffix("ticks"));
                infoList.add(new LogicInfo(id, 2, 9, (Object)((int)greenhouse.getEnergyUsage())).addSuffix("rf/t"));
            }
        }
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"Calculator");
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }
}

