/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import buildcraft.api.power.ILaserTarget;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.tiles.IHeatable;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class BuildcraftProvider
extends TileProvider {
    public static String name = "Buildcraft-Provider";
    public static String[] categories = new String[]{"Buildcraft: General", "Buildcraft: Lasers"};
    public static String[] subcategories = new String[]{"Active", "Current Heat", "Min Heat", "Max Heat", "Ideal Heat", "Requires Energy", "Valid Target"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && (te instanceof IHasWork || te instanceof IHeatable || te instanceof ILaserTarget);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        int id = this.getID();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te instanceof IHasWork) {
            IHasWork worker = (IHasWork)te;
            infoList.add(new LogicInfo(id, 0, 0, (Object)worker.hasWork()));
        }
        if (te instanceof IHeatable) {
            IHeatable heat = (IHeatable)te;
            infoList.add(new LogicInfo(id, 0, 1, (Object)((int)heat.getCurrentHeatValue())).addSuffix("degrees"));
            infoList.add(new LogicInfo(id, 0, 2, (Object)((int)heat.getMinHeatValue())).addSuffix("degrees"));
            infoList.add(new LogicInfo(id, 0, 3, (Object)((int)heat.getMaxHeatValue())).addSuffix("degrees"));
            infoList.add(new LogicInfo(id, 0, 4, (Object)((int)heat.getIdealHeatValue())).addSuffix("degrees"));
        }
        if (te instanceof ILaserTarget) {
            ILaserTarget laser = (ILaserTarget)te;
            infoList.add(new LogicInfo(id, 1, 5, (Object)laser.requiresLaserEnergy()));
            infoList.add(new LogicInfo(id, 1, 6, (Object)laser.isInvalidTarget()));
        }
    }

    @Override
    public String getCategory(int id) {
        return categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"BuildCraft|Core");
    }
}

