/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ISegmentedReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class BloodMagicProvider
extends TileProvider {
    public static String name = "BloodMagic-Provider";
    public String[] categories = new String[]{"Blood Altar", "Reagent Handler", "Ritual Stone"};
    public String[] subcategories = new String[]{"Tier", "Blood Stored", "Capacity", "Buffer Capacity", "Progress", "Has Demon Blood", "Connected Tanks", "Owner", "Cool Down", "Are Tanks Empty"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && (te instanceof IBloodAltar || te instanceof IReagentHandler);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IReagentHandler handler;
        int id = this.getID();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te instanceof IBloodAltar) {
            IBloodAltar altar = (IBloodAltar)te;
            infoList.add(new LogicInfo(id, 0, 0, (Object)altar.getTier()));
            infoList.add(new LogicInfo(id, 0, 1, (Object)altar.getCurrentBlood()).addSuffix("LP"));
            infoList.add(new LogicInfo(id, 0, 2, (Object)altar.getCapacity()).addSuffix("LP"));
            infoList.add(new LogicInfo(id, 0, 3, (Object)altar.getBufferCapacity()).addSuffix("LP"));
            infoList.add(new LogicInfo(id, 0, 4, (Object)altar.getProgress()));
            infoList.add(new LogicInfo(id, 0, 5, (Object)altar.hasDemonBlood()));
        }
        if (te instanceof IReagentHandler) {
            handler = (IReagentHandler)te;
            ReagentContainerInfo[] containerList = handler.getContainerInfo(dir);
            int tankID = 0;
            for (ReagentContainerInfo info : containerList) {
                if (info == null) continue;
                ++tankID;
                String prefix = "";
                if (containerList.length > 1) {
                    prefix = "Tank " + tankID + ": ";
                }
                String category = this.getCategory(1);
                infoList.add(new LogicInfo(id, category, prefix + "Capacity", (Object)info.capacity));
                if (info.reagent != null) {
                    infoList.add(new LogicInfo(id, category, prefix + "Stored", (Object)info.reagent.amount));
                    infoList.add(new LogicInfo(id, category, prefix + "Reagent", (Object)info.reagent.reagent.name));
                    continue;
                }
                infoList.add(new LogicInfo(id, category, prefix + "Stored", (Object)0));
                infoList.add(new LogicInfo(id, category, prefix + "Reagent", (Object)"NONE"));
            }
        }
        if (te instanceof ISegmentedReagentHandler) {
            handler = (ISegmentedReagentHandler)te;
            infoList.add(new LogicInfo(id, 1, 6, (Object)handler.getNumberOfTanks()));
        }
        if (te instanceof IMasterRitualStone) {
            IMasterRitualStone stone = (IMasterRitualStone)te;
            infoList.add(new LogicInfo(id, 2, 7, (Object)stone.getOwner()));
            infoList.add(new LogicInfo(id, 2, 8, (Object)stone.getCooldown()));
            infoList.add(new LogicInfo(id, 2, 9, (Object)stone.areTanksEmpty()));
        }
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"AWWayofTime");
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }
}

