/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;
import sonar.logistics.info.types.BlockNameInfo;
import sonar.logistics.info.types.ModidInfo;

public class BlockProvider
extends TileProvider {
    public static String name = "Block-Helper";
    public String[] categories = new String[]{"GENERAL", "WORLD", "PROPERTIES", "REDSTONE", "FLUID"};
    public String[] subcategories = new String[]{"Metadata", "X Coord", "Y Coord", "Z Coord", "Direction", "Is Raining", "Is Thundering", "Save Name", "Dimension", "Dimension Name", "Light", "Is Side Solid", "Hardness", "Signal", "Weak Power", "Strong Power", "Temperature", "Density", "Viscosity", "Block Name", "Mod"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        Block target = world.func_147439_a(x, y, z);
        return target != null;
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        GameRegistry.UniqueIdentifier unique;
        int meta;
        int id = this.getID();
        Block target = world.func_147439_a(x, y, z);
        ItemStack block = SonarHelper.createStackedBlock((Block)target, (int)(meta = world.func_72805_g(x, y, z)));
        if (block != null) {
            infoList.add(new BlockNameInfo(id, 0, 19, (Object)"ERROR", block));
        }
        if ((unique = GameRegistry.findUniqueIdentifierFor((Block)target)) != null) {
            infoList.add(new ModidInfo(id, 0, 20, (Object)meta, unique));
        }
        infoList.add(new LogicInfo(id, 0, 0, (Object)meta));
        infoList.add(new LogicInfo(id, 0, 1, (Object)x));
        infoList.add(new LogicInfo(id, 0, 2, (Object)y));
        infoList.add(new LogicInfo(id, 0, 3, (Object)z));
        infoList.add(new LogicInfo(id, 0, 4, (Object)("" + dir)));
        infoList.add(new LogicInfo(id, 1, 5, (Object)("" + world.func_72912_H().func_76059_o())));
        infoList.add(new LogicInfo(id, 1, 6, (Object)("" + world.func_72912_H().func_76061_m())));
        infoList.add(new LogicInfo(id, 1, 7, (Object)("" + world.func_72912_H().func_76065_j())));
        infoList.add(new LogicInfo(id, 1, 8, (Object)world.field_73011_w.field_76574_g));
        infoList.add(new LogicInfo(id, 1, 9, (Object)("" + world.field_73011_w.func_80007_l())));
        infoList.add(new LogicInfo(id, 2, 10, (Object)world.func_72957_l(x, y, z)));
        infoList.add(new LogicInfo(id, 2, 11, (Object)("" + target.isSideSolid((IBlockAccess)world, x, y, z, dir))));
        infoList.add(new LogicInfo(id, 2, 12, (Object)("" + target.func_149712_f(world, x, y, z))));
        infoList.add(new LogicInfo(id, 3, 13, (Object)("" + world.func_72864_z(x, y, z))));
        if (target.func_149744_f()) {
            infoList.add(new LogicInfo(id, 3, 14, (Object)target.func_149709_b((IBlockAccess)world, x, y, z, dir.ordinal())));
            infoList.add(new LogicInfo(id, 3, 15, (Object)target.func_149748_c((IBlockAccess)world, x, y, z, dir.ordinal())));
        }
        if (target instanceof BlockFluidBase) {
            BlockFluidBase fluid = (BlockFluidBase)target;
            infoList.add(new LogicInfo(id, 4, 16, (Object)fluid.getFluid().getTemperature()));
            infoList.add(new LogicInfo(id, 4, 17, (Object)fluid.getFluid().getDensity()));
            infoList.add(new LogicInfo(id, 4, 18, (Object)fluid.getFluid().getViscosity()));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }
}

