/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import erogenousbeef.bigreactors.common.interfaces.IReactorFuelInfo;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IActivateable;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class BigReactorsProvider
extends TileProvider {
    public static String name = "Big-Reactors";
    public String[] categories = new String[]{"Big Reactor General", "Big Reactor Fuel"};
    public String[] subcategories = new String[]{"Connected Blocks", "Is Active", "Energy Generated", "Core Heat", "Casing Heat", "Fluid Consumed", "Intake Rate", "Max Intake Rate", "Rotor Speed", "Max Rotor Speed", "Rotor Mass", "Rotor Blades", "Current Fuel", "Current Waste", "Capacity", "Fuel Rods"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && target instanceof IMultiblockPart;
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IMultiblockPart) {
            IMultiblockPart part = (IMultiblockPart)target;
            MultiblockControllerBase controller = part.getMultiblockController();
            infoList.add(new LogicInfo(id, 0, 0, (Object)controller.getNumConnectedBlocks()));
            if (controller instanceof IActivateable) {
                IActivateable activate = (IActivateable)controller;
                infoList.add(new LogicInfo(id, 0, 1, (Object)activate.getActive()));
            }
            if (controller instanceof MultiblockReactor) {
                MultiblockReactor reactor = (MultiblockReactor)controller;
                infoList.add(new LogicInfo(id, 0, 2, (Object)((long)reactor.getEnergyGeneratedLastTick())).addSuffix("RF"));
                infoList.add(new LogicInfo(id, 1, 3, (Object)((long)reactor.getFuelHeat())).addSuffix("C"));
                infoList.add(new LogicInfo(id, 0, 4, (Object)((long)reactor.getReactorHeat())).addSuffix("C"));
            }
            if (controller instanceof MultiblockTurbine) {
                MultiblockTurbine turbine = (MultiblockTurbine)controller;
                infoList.add(new LogicInfo(id, 0, 2, (Object)((long)turbine.getEnergyGeneratedLastTick())).addSuffix("RF"));
                infoList.add(new LogicInfo(id, 0, 5, (Object)turbine.getFluidConsumedLastTick()).addSuffix("mB"));
                infoList.add(new LogicInfo(id, 0, 6, (Object)turbine.getMaxIntakeRate()).addSuffix("mB/T"));
                infoList.add(new LogicInfo(id, 0, 7, (Object)turbine.getMaxIntakeRateMax()).addSuffix("mB/T"));
                infoList.add(new LogicInfo(id, 0, 8, (Object)((long)turbine.getRotorSpeed())).addSuffix("RPM"));
                infoList.add(new LogicInfo(id, 0, 9, (Object)((long)turbine.getMaxRotorSpeed())).addSuffix("RPM"));
                infoList.add(new LogicInfo(id, 0, 10, (Object)turbine.getRotorMass()));
                infoList.add(new LogicInfo(id, 0, 11, (Object)turbine.getNumRotorBlades()));
            }
            if (controller instanceof IReactorFuelInfo) {
                IReactorFuelInfo fuelInfo = (IReactorFuelInfo)controller;
                infoList.add(new LogicInfo(id, 1, 12, (Object)fuelInfo.getFuelAmount()).addSuffix("mB"));
                infoList.add(new LogicInfo(id, 1, 13, (Object)fuelInfo.getWasteAmount()).addSuffix("mB"));
                infoList.add(new LogicInfo(id, 1, 14, (Object)fuelInfo.getCapacity()).addSuffix("mB"));
                infoList.add(new LogicInfo(id, 1, 15, (Object)fuelInfo.getFuelRodCount()));
            }
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"BigReactors");
    }
}

