/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.storage.TileDrive;
import cpw.mods.fml.common.Loader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.TileProvider;

public class AE2GridProvider
extends TileProvider {
    public static String name = "AE2-Grid-Provider";
    public String[] categories = new String[]{"AE2 Energy", "AE2 Channels", "AE2 Storage"};
    public String[] subcategories = new String[]{"Idle Power Usage", "Used Channels", "Is Active", "Is Powered", "Item Types", "Fluid Types", "Cell Count", "Total Cells", "Used Bytes", "Total Bytes", "Stored Item Types", "Total Item Types", "Stored Fluid Types", "Total Fluid Types"};

    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IGridBlock || target instanceof IGridConnection || target instanceof IPowerChannelState || target instanceof IGridProxyable);
    }

    @Override
    public void getTileInfo(List<ILogicInfo> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IGridProxyable proxy;
        IGrid grid;
        IGridBlock grid2;
        int id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IGridBlock) {
            grid2 = (IGridBlock)target;
            infoList.add(new LogicInfo(id, 0, 0, (Object)((int)grid2.getIdlePowerUsage())).addSuffix("ae/t"));
        }
        if (target instanceof IGridConnection) {
            grid2 = (IGridConnection)target;
            infoList.add(new LogicInfo(id, 1, 1, (Object)grid2.getUsedChannels()));
        }
        if (target instanceof IPowerChannelState) {
            grid2 = (IPowerChannelState)target;
            infoList.add(new LogicInfo(id, 1, 2, (Object)grid2.isActive()));
            infoList.add(new LogicInfo(id, 1, 3, (Object)grid2.isPowered()));
        }
        if (target instanceof IGridProxyable && (grid = (proxy = (IGridProxyable)target).getProxy().getNode().getGrid()) != null) {
            long usedCells = 0L;
            long totalCells = 0L;
            long usedBytes = 0L;
            long totalBytes = 0L;
            long usedTypes = 0L;
            long totalTypes = 0L;
            long usedTypesF = 0L;
            long totalTypesF = 0L;
            IMachineSet set = grid.getMachines(TileDrive.class);
            Iterator drives = set.iterator();
            while (drives.hasNext()) {
                IGridHost node = ((IGridNode)drives.next()).getMachine();
                if (!(node instanceof TileDrive)) continue;
                TileDrive drive = (TileDrive)node;
                totalCells += (long)drive.getCellCount();
                for (int i = 0; i < drive.getInternalInventory().func_70302_i_(); ++i) {
                    ItemStack is = drive.getInternalInventory().func_70301_a(i);
                    if (is == null) continue;
                    IMEInventoryHandler itemInventory = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
                    IMEInventoryHandler fluidInventory = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.FLUIDS);
                    for (IMEInventoryHandler handler : Arrays.asList(itemInventory, fluidInventory)) {
                        ICellInventoryHandler cell;
                        ICellInventory cellInventory;
                        if (!(handler instanceof ICellInventoryHandler) || (cellInventory = (cell = (ICellInventoryHandler)handler).getCellInv()) == null) continue;
                        totalBytes += cellInventory.getTotalBytes();
                        usedBytes += cellInventory.getUsedBytes();
                        totalTypes += cellInventory.getTotalItemTypes();
                        usedTypes += cellInventory.getStoredItemTypes();
                    }
                }
            }
            infoList.add(new StorageInfo(id, 2, 6, (Object)usedCells).addSuffix("cells"));
            infoList.add(new StorageInfo(id, 2, 7, (Object)totalCells).addSuffix("cells"));
            infoList.add(new StorageInfo(id, 2, 8, (Object)usedBytes).addSuffix("bytes"));
            infoList.add(new StorageInfo(id, 2, 9, (Object)totalBytes).addSuffix("bytes"));
            infoList.add(new StorageInfo(id, 2, 10, (Object)usedTypes));
            infoList.add(new StorageInfo(id, 2, 11, (Object)totalTypes));
            infoList.add(new StorageInfo(id, 2, 12, (Object)usedTypesF));
            infoList.add(new StorageInfo(id, 2, 13, (Object)totalTypesF));
        }
    }

    @Override
    public String getCategory(int id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(int id) {
        return this.subcategories[id];
    }

    public boolean isLoadable() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    public static class StorageInfo
    extends LogicInfo {
        public StorageInfo() {
        }

        public StorageInfo(int providerID, int category, int subCategory, Object data) {
            super(providerID, category, subCategory, data);
        }

        public StorageInfo(int providerID, String category, String subCategory, Object data) {
            super(providerID, category, subCategory, data);
        }

        @Override
        public int updateTicks() {
            return 20;
        }
    }
}

