/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.interaction;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.api.StoredItemStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.logistics.Logistics;
import sonar.logistics.api.render.InfoInteractionHandler;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.info.types.InventoryInfo;
import sonar.logistics.network.packets.PacketScreenInteraction;

public class InventoryInteraction
extends InfoInteractionHandler<InventoryInfo> {
    public String getName() {
        return "Inventory Info";
    }

    @Override
    public void handleInteraction(InventoryInfo info, ScreenType type, TileEntity screen, EntityPlayer player, int x, int y, int z, BlockInteraction interact) {
        TileHandler screenHandler = FMPHelper.getHandler((Object)screen);
        ForgeDirection dir = interact.getDir();
        BlockCoords screenCoords = new BlockCoords(screen);
        if (interact.type == BlockInteractionType.RIGHT || interact.type == BlockInteractionType.SHIFT_RIGHT) {
            if (interact.type == BlockInteractionType.RIGHT) {
                if (player.func_70694_bm() != null) {
                    Logistics.network.sendToServer((IMessage)new PacketScreenInteraction.PacketItemStack(screen.field_145851_c, screen.field_145848_d, screen.field_145849_e, x, y, z, interact, new StoredItemStack(player.func_70694_bm())));
                }
            } else if (interact.type == BlockInteractionType.SHIFT_RIGHT) {
                // empty if block
            }
        } else if (screenHandler instanceof LargeDisplayScreenHandler) {
            LargeDisplayScreenHandler largeScreen = (LargeDisplayScreenHandler)screenHandler;
            LargeScreenSizing sizing = largeScreen.sizing;
            if (sizing != null) {
                StoredItemStack stack;
                int hSlots;
                int slot = -1;
                if (dir == ForgeDirection.NORTH) {
                    hSlots = Math.round(sizing.maxH - sizing.minH) * 2;
                    int yPos = (sizing.maxY - (y - screenCoords.getY())) * 2;
                    int hPos = (sizing.maxH - (x - screenCoords.getX())) * 2;
                    int hSlot = (double)interact.hitx < 0.5 ? hPos + 1 : hPos;
                    int ySlot = (double)interact.hity < 0.5 ? yPos + 1 : yPos;
                    slot = ySlot * hSlots + hSlot + ySlot * 2;
                } else if (dir == ForgeDirection.SOUTH) {
                    hSlots = Math.round(sizing.maxH - sizing.minH) * 2;
                    int yPos = (sizing.maxY - (y - screenCoords.getY())) * 2;
                    int hPos = (sizing.maxH - sizing.minH + (x - screenCoords.getX())) * 2;
                    int hSlot = (double)interact.hitx < 0.5 ? hPos : hPos + 1;
                    int ySlot = (double)interact.hity < 0.5 ? yPos + 1 : yPos;
                    slot = ySlot * hSlots + hSlot + ySlot * 2 - sizing.maxH * 2;
                } else if (dir == ForgeDirection.EAST) {
                    hSlots = Math.round(sizing.maxH - sizing.minH) * 2;
                    int yPos = (sizing.maxY - (y - screenCoords.getY())) * 2;
                    int hPos = (sizing.maxH - (z - screenCoords.getZ())) * 2;
                    int hSlot = (double)interact.hitz < 0.5 ? hPos + 1 : hPos;
                    int ySlot = (double)interact.hity < 0.5 ? yPos + 1 : yPos;
                    slot = ySlot * hSlots + hSlot + ySlot * 2;
                } else if (dir == ForgeDirection.WEST) {
                    hSlots = Math.round(sizing.maxH - sizing.minH) * 2;
                    int yPos = (sizing.maxY - (y - screenCoords.getY())) * 2;
                    int hPos = (sizing.maxH - sizing.minH + (z - screenCoords.getZ())) * 2;
                    int hSlot = (double)interact.hitz < 0.5 ? hPos : hPos + 1;
                    int ySlot = (double)interact.hity < 0.5 ? yPos + 1 : yPos;
                    slot = ySlot * hSlots + hSlot + ySlot * 2 - sizing.maxH * 2;
                }
                if (slot >= 0 && slot < info.stacks.items.size() && (stack = info.stacks.items.get(slot)) != null) {
                    Logistics.network.sendToServer((IMessage)new PacketScreenInteraction.PacketItemStack(screen.field_145851_c, screen.field_145848_d, screen.field_145849_e, x, y, z, interact, stack));
                }
            }
        } else {
            StoredItemStack stack;
            int slot = -1;
            if (dir == ForgeDirection.NORTH) {
                slot = (double)interact.hitx < 0.5 ? 1 : 0;
            } else if (dir == ForgeDirection.SOUTH) {
                slot = (double)interact.hitx < 0.5 ? 0 : 1;
            } else if (dir == ForgeDirection.EAST) {
                slot = (double)interact.hitz < 0.5 ? 1 : 0;
            } else if (dir == ForgeDirection.WEST) {
                int n = slot = (double)interact.hitz < 0.5 ? 0 : 1;
            }
            if (slot >= 0 && slot < info.stacks.items.size() && (stack = info.stacks.items.get(slot)) != null) {
                Logistics.network.sendToServer((IMessage)new PacketScreenInteraction.PacketItemStack(screen.field_145851_c, screen.field_145848_d, screen.field_145849_e, x, y, z, interact, stack));
            }
        }
    }
}

