/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.interaction;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.api.StoredFluidStack;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.logistics.Logistics;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.render.InfoInteractionHandler;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.info.types.FluidInventoryInfo;
import sonar.logistics.network.packets.PacketScreenInteraction;

public class FluidInventoryInteraction
extends InfoInteractionHandler<FluidInventoryInfo> {
    public String getName() {
        return "Fluid Inventory";
    }

    @Override
    public void handleInteraction(FluidInventoryInfo info, ScreenType type, TileEntity screen, EntityPlayer player, int x, int y, int z, BlockInteraction interact) {
        ILargeDisplay largeScreen;
        LargeScreenSizing sizing;
        ForgeDirection dir = ForgeDirection.getOrientation((int)interact.side);
        BlockCoords screenCoords = new BlockCoords(screen);
        if (interact.type == BlockInteractionType.RIGHT) {
            Logistics.network.sendToServer((IMessage)new PacketScreenInteraction.PacketFluidStack(screen.field_145851_c, screen.field_145848_d, screen.field_145849_e, x, y, z, interact, null));
        }
        if (screen instanceof ILargeDisplay && (sizing = (largeScreen = (ILargeDisplay)screen).getSizing()) != null) {
            StoredFluidStack stack;
            int hSlots;
            int slot = -1;
            if (dir == ForgeDirection.NORTH) {
                hSlots = Math.round(sizing.maxH - sizing.minH);
                int yPos = sizing.maxY - (y - screenCoords.getY());
                int hPos = sizing.maxH - (x - screenCoords.getX());
                slot = yPos * hSlots + hPos + yPos;
            } else if (dir == ForgeDirection.SOUTH) {
                hSlots = Math.round(sizing.maxH - sizing.minH);
                int yPos = sizing.maxY - (y - screenCoords.getY());
                int hPos = sizing.maxH - sizing.minH + (x - screenCoords.getX());
                slot = yPos * hSlots + hPos + yPos - sizing.maxH;
            } else if (dir == ForgeDirection.EAST) {
                hSlots = Math.round(sizing.maxH - sizing.minH);
                int yPos = sizing.maxY - (y - screenCoords.getY());
                int hPos = sizing.maxH - (z - screenCoords.getZ());
                slot = yPos * hSlots + hPos + yPos;
            } else if (dir == ForgeDirection.WEST) {
                hSlots = Math.round(sizing.maxH - sizing.minH);
                int yPos = sizing.maxY - (y - screenCoords.getY());
                int hPos = sizing.maxH - sizing.minH + (z - screenCoords.getZ());
                slot = yPos * hSlots + hPos + yPos - sizing.maxH;
            }
            if (slot >= 0 && slot < info.stacks.fluids.size() && (stack = info.stacks.fluids.get(slot)) != null) {
                Logistics.network.sendToServer((IMessage)new PacketScreenInteraction.PacketFluidStack(screen.field_145851_c, screen.field_145848_d, screen.field_145849_e, x, y, z, interact, stack));
            }
        }
    }
}

