/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.filters.items;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import sonar.logistics.api.utils.ItemFilter;

public class OreDictionaryFilter
extends ItemFilter<OreDictionaryFilter> {
    public String oreDict = "";

    @Override
    public String getName() {
        return "OreDict Filter";
    }

    @Override
    public boolean matchesFilter(ItemStack stack) {
        if (this.oreDict != null && stack != null) {
            int[] names;
            int[] nArray = names = OreDictionary.getOreIDs((ItemStack)stack);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer id = nArray[i];
                if (!OreDictionary.getOreName((int)id).equals(this.oreDict)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equalFilter(ItemFilter itemFilter) {
        if (itemFilter != null && itemFilter instanceof OreDictionaryFilter) {
            OreDictionaryFilter oFilter = (OreDictionaryFilter)itemFilter;
            if (oFilter.oreDict.equals(this.oreDict)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ore", this.oreDict);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.oreDict = tag.func_74779_i("ore");
    }

    public void readFromBuf(ByteBuf buf) {
        this.oreDict = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.oreDict);
    }

    @Override
    public OreDictionaryFilter instance() {
        return new OreDictionaryFilter();
    }

    @Override
    public List<ItemStack> getFilters() {
        if (this.oreDict != null) {
            return OreDictionary.getOres((String)this.oreDict);
        }
        return Collections.EMPTY_LIST;
    }
}

