/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.filters.items;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.ItemStackHelper;
import sonar.logistics.api.utils.ItemFilter;

public class ItemStackFilter
extends ItemFilter<ItemStackFilter>
implements IInventory {
    public ItemStack[] filters = new ItemStack[1];
    public boolean matchNBT;
    public boolean ignoreDamage;
    public boolean matchOreDict;
    public boolean matchModid;

    @Override
    public String getName() {
        return "ItemStack Filter";
    }

    @Override
    public boolean matchesFilter(ItemStack stack) {
        int slotID = 0;
        return stack != null && this.filters[slotID] != null && (stack.func_77973_b() == this.filters[slotID].func_77973_b() || this.matchModid && ItemStackHelper.matchingModid((ItemStack)this.filters[slotID], (ItemStack)stack) || this.matchOreDict && ItemStackHelper.matchingOreDictID((ItemStack)this.filters[slotID], (ItemStack)stack)) && (this.ignoreDamage || stack.func_77960_j() == this.filters[slotID].func_77960_j()) && (!this.matchNBT || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.filters[slotID]));
    }

    @Override
    public boolean equalFilter(ItemFilter itemFilter) {
        if (itemFilter != null && itemFilter instanceof ItemStackFilter) {
            ItemStackFilter sFilter = (ItemStackFilter)itemFilter;
            if (this.filters[0] != null && sFilter.matchNBT == this.matchNBT && sFilter.ignoreDamage == this.ignoreDamage && sFilter.matchOreDict == this.matchOreDict && sFilter.matchModid == this.matchModid && ItemStack.func_77989_b((ItemStack)this.filters[0], (ItemStack)sFilter.filters[0])) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> getFilters() {
        return Arrays.asList(this.filters);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("matchNBT", this.matchNBT);
        tag.func_74757_a("ignoreDamage", this.ignoreDamage);
        tag.func_74757_a("matchOreDict", this.matchOreDict);
        tag.func_74757_a("matchModid", this.matchModid);
        NBTTagCompound stackTag = new NBTTagCompound();
        if (this.filters[0] != null) {
            this.filters[0].func_77955_b(stackTag);
            tag.func_74782_a("stackTag", (NBTBase)stackTag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.matchNBT = tag.func_74767_n("matchNBT");
        this.ignoreDamage = tag.func_74767_n("ignoreDamage");
        this.matchOreDict = tag.func_74767_n("matchOreDict");
        this.matchModid = tag.func_74767_n("matchModid");
        if (tag.func_74764_b("stackTag")) {
            this.filters[0] = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("stackTag"));
        }
    }

    public void readFromBuf(ByteBuf buf) {
        this.matchNBT = buf.readBoolean();
        this.ignoreDamage = buf.readBoolean();
        this.matchOreDict = buf.readBoolean();
        this.matchModid = buf.readBoolean();
        if (buf.readBoolean()) {
            this.filters[0] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeBoolean(this.matchNBT);
        buf.writeBoolean(this.ignoreDamage);
        buf.writeBoolean(this.matchOreDict);
        buf.writeBoolean(this.matchModid);
        if (this.filters[0] != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.filters[0]);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public ItemStackFilter instance() {
        return new ItemStackFilter();
    }

    public int func_70302_i_() {
        return this.filters.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.filters[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        this.filters[slot] = null;
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack != null) {
            ItemStack filterStack = stack.func_77946_l();
            filterStack.field_77994_a = 1;
            this.filters[slot] = filterStack;
        } else {
            this.filters[slot] = null;
        }
    }

    public String func_145825_b() {
        return "ItemStack Filter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

