/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.Logistics;
import sonar.logistics.api.cache.EmptyNetworkCache;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IChannelProvider;
import sonar.logistics.api.connecting.IConnectionNode;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.api.wrappers.CablingWrapper;
import sonar.logistics.cache.LocalNetworkCache;
import sonar.logistics.registries.CableRegistry;
import sonar.logistics.registries.CacheRegistry;

public class WIPCableHelper
extends CablingWrapper {
    @Override
    public void addConnection(TileEntity connection, ForgeDirection side) {
        IDataCable cable;
        Object adjacent = FMPHelper.getAdjacentTile((TileEntity)connection, (ForgeDirection)side);
        if (adjacent != null && adjacent instanceof IDataCable && !(cable = (IDataCable)adjacent).isBlocked(side.getOpposite())) {
            this.addConnection(cable.registryID(), new BlockCoords(connection));
        }
    }

    @Override
    public void addConnection(int registryID, BlockCoords coords) {
        CableRegistry.addConnection(registryID, coords);
    }

    @Override
    public void removeConnection(TileEntity connection, ForgeDirection side) {
        IDataCable cable;
        Object adjacent = FMPHelper.getAdjacentTile((TileEntity)connection, (ForgeDirection)side);
        TileHandler handler = FMPHelper.getHandler((Object)adjacent);
        if (adjacent != null && adjacent instanceof IDataCable && !(cable = (IDataCable)adjacent).isBlocked(side.getOpposite())) {
            this.removeConnection(cable.registryID(), new BlockCoords(connection));
        }
    }

    @Override
    public void removeConnection(int registryID, BlockCoords coords) {
        CableRegistry.removeConnection(registryID, coords);
    }

    @Override
    public void addCable(IDataCable cable) {
        for (int i = 0; i < 6; ++i) {
            int id;
            BlockCoords adj;
            Object target;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (cable.isBlocked(dir.getOpposite()) || (target = FMPHelper.getTile((Object)(adj = BlockCoords.translateCoords((BlockCoords)cable.getCoords(), (ForgeDirection)dir)).getTileEntity())) == null || !(target instanceof IDataCable) || (id = ((IDataCable)target).registryID()) == -1 || !cable.getCableType().canConnect(cable.getCableType())) continue;
            cable.setRegistryID(id);
            return;
        }
    }

    @Override
    public void removeCable(IDataCable cable) {
        CableRegistry.removeCable(cable.registryID(), cable);
    }

    @Override
    public void refreshConnections(IDataCable cable) {
        for (int i = 0; i < 6; ++i) {
            BlockCoords adj;
            Object target;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (cable.isBlocked(dir.getOpposite()) || (target = FMPHelper.getTile((Object)(adj = BlockCoords.translateCoords((BlockCoords)cable.getCoords(), (ForgeDirection)dir)).getTileEntity())) == null || target instanceof IDataCable || !(target instanceof IInfoEmitter)) continue;
            IInfoEmitter tile = (IInfoEmitter)target;
            tile.removeConnections();
            tile.addConnections();
        }
    }

    @Override
    public INetworkCache getNetwork(TileEntity tile, ForgeDirection dir) {
        int registryID = -1;
        CableType cableType = CableType.NONE;
        Object adjacent = FMPHelper.getAdjacentTile((TileEntity)tile, (ForgeDirection)dir);
        if (adjacent != null) {
            if (adjacent instanceof IDataCable) {
                IDataCable cable = (IDataCable)adjacent;
                if (cable.isBlocked(dir.getOpposite())) {
                    return new EmptyNetworkCache();
                }
                registryID = cable.registryID();
                cableType = cable.getCableType();
            } else {
                if (adjacent instanceof IChannelProvider) {
                    return new LocalNetworkCache((ILogicTile)adjacent);
                }
                if (adjacent instanceof ILogicTile) {
                    return new LocalNetworkCache((ILogicTile)adjacent);
                }
            }
        }
        if (registryID != -1) {
            try {
                return CacheRegistry.getCache(registryID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new EmptyNetworkCache();
    }

    public Map<BlockCoords, ForgeDirection> getTileConnections(List<BlockCoords> network) {
        if (network == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<BlockCoords, ForgeDirection> connections = new LinkedHashMap<BlockCoords, ForgeDirection>();
        for (BlockCoords connect : network) {
            TileEntity node = connect.getTileEntity();
            if (node == null || !(node instanceof IConnectionNode)) continue;
            ((IConnectionNode)node).addConnections(connections);
        }
        return connections;
    }

    public Map<BlockCoords, ForgeDirection> getTileConnections(TileEntity tile, ForgeDirection dir) {
        LinkedHashMap<BlockCoords, ForgeDirection> connections = new LinkedHashMap<BlockCoords, ForgeDirection>();
        int registryID = -1;
        CableType cableType = CableType.NONE;
        Object adjacent = FMPHelper.getAdjacentTile((TileEntity)tile, (ForgeDirection)dir);
        if (adjacent != null) {
            if (adjacent instanceof IDataCable) {
                IDataCable cable = (IDataCable)adjacent;
                if (cable.isBlocked(dir.getOpposite())) {
                    return connections;
                }
                registryID = cable.registryID();
                cableType = cable.getCableType();
            } else if (adjacent instanceof IConnectionNode) {
                IConnectionNode node = (IConnectionNode)adjacent;
                node.addConnections(connections);
            }
        }
        if (registryID != -1) {
            try {
                LinkedHashMap<BlockCoords, ForgeDirection> cacheList = CacheRegistry.getChannelArray(registryID);
                if (!cacheList.isEmpty()) {
                    if (cableType.hasUnlimitedConnections()) {
                        connections.putAll(cacheList);
                    } else {
                        for (Map.Entry<BlockCoords, ForgeDirection> entry : cacheList.entrySet()) {
                            if (entry.getKey().getBlock(entry.getKey().getWorld()) == null) continue;
                            connections.put(entry.getKey(), entry.getValue());
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logistics.logger.error("CableHelper: " + exception.getLocalizedMessage());
            }
        }
        return connections;
    }

    @Override
    public CableType canRenderConnection(TileEntity te, ForgeDirection dir, CableType cableType) {
        Object target = FMPHelper.getTile((Object)te);
        Object tile = SonarHelper.getAdjacentTileEntity((TileEntity)te, (ForgeDirection)dir);
        if ((tile = FMPHelper.checkObject((Object)tile)) != null) {
            if (tile instanceof IDataCable) {
                IDataCable cable = (IDataCable)tile;
                if (target instanceof IDataCable && !cable.getCableType().canConnect(((IDataCable)target).getCableType())) {
                    return CableType.NONE;
                }
                if (!cable.isBlocked(dir.getOpposite()) && cableType.canConnect(cable.getCableType())) {
                    return cable.getCableType();
                }
            } else if (tile instanceof ILogicTile) {
                boolean canConnect = ((ILogicTile)tile).canConnect(dir.getOpposite());
                if (canConnect && target instanceof IDataCable && cableType.canConnect(((IDataCable)target).getCableType())) {
                    return ((IDataCable)target).getCableType();
                }
                return canConnect ? CableType.DATA_CABLE : CableType.NONE;
            }
        }
        return CableType.NONE;
    }
}

