/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.ActionType;
import sonar.core.api.BlockCoords;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketInvUpdate;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.cache.IStorageCache;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.wrappers.ItemWrapper;

public class ItemHelper
extends ItemWrapper {
    @Override
    public ItemWrapper.StorageItems getItems(INetworkCache network) {
        if (network instanceof IStorageCache) {
            return ((IStorageCache)network).getStoredItems();
        }
        return ItemWrapper.StorageItems.EMPTY;
    }

    @Override
    public InventoryHandler.StorageSize getTileInventory(List<StoredItemStack> storedStacks, InventoryHandler.StorageSize storage, Map<BlockCoords, ForgeDirection> connections) {
        for (Map.Entry<BlockCoords, ForgeDirection> entry : connections.entrySet()) {
            storage = this.getTileInventory(storedStacks, storage, entry);
        }
        return storage;
    }

    public InventoryHandler.StorageSize getTileInventory(List<StoredItemStack> storedStacks, InventoryHandler.StorageSize storage, Map.Entry<BlockCoords, ForgeDirection> entry) {
        TileEntity tile = entry.getKey().getTileEntity();
        if (tile == null) {
            return storage;
        }
        boolean specialProvider = false;
        for (InventoryHandler provider : SonarCore.inventoryProviders.getObjects()) {
            InventoryHandler.StorageSize size;
            if (!provider.canHandleItems(tile, entry.getValue()) || specialProvider || (size = provider.getItems(storedStacks, tile, entry.getValue())) == InventoryHandler.StorageSize.EMPTY) continue;
            specialProvider = true;
            storage.addItems(size.getStoredFluids());
            storage.addStorage(size.getMaxFluids());
        }
        return storage;
    }

    @Override
    public InventoryHandler.StorageSize getEntityInventory(List<StoredItemStack> storedStacks, InventoryHandler.StorageSize storage, List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            InventoryHandler.StorageSize size = SonarAPI.getItemHelper().addInventoryToList(storedStacks, (IInventory)player.field_71071_by);
            storage.addItems(size.getStoredFluids());
            storage.addStorage(size.getMaxFluids());
        }
        return storage;
    }

    @Override
    public StoredItemStack addItems(StoredItemStack add, INetworkCache network, ActionType action) {
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        for (Map.Entry entry : connections.entrySet()) {
            TileEntity tile = ((BlockCoords)entry.getKey()).getTileEntity();
            for (InventoryHandler provider : SonarCore.inventoryProviders.getObjects()) {
                if (!provider.canHandleItems(tile, (ForgeDirection)entry.getValue()) || (add = provider.addStack(add, tile, (ForgeDirection)entry.getValue(), action)) != null) continue;
                return null;
            }
        }
        return add;
    }

    @Override
    public StoredItemStack removeItems(StoredItemStack remove, INetworkCache network, ActionType action) {
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        for (Map.Entry entry : connections.entrySet()) {
            TileEntity tile = ((BlockCoords)entry.getKey()).getTileEntity();
            for (InventoryHandler provider : SonarCore.inventoryProviders.getObjects()) {
                if (!provider.canHandleItems(tile, (ForgeDirection)entry.getValue()) || (remove = provider.removeStack(remove, tile, (ForgeDirection)entry.getValue(), action)) != null) continue;
                return null;
            }
        }
        return remove;
    }

    @Override
    public StoredItemStack getStack(INetworkCache network, int slot) {
        Map.Entry<BlockCoords, ForgeDirection> block = network.getExternalBlock(true);
        StoredItemStack stack = this.getTileStack(network, slot);
        if (stack == null) {
            network.getFirstConnection(CacheTypes.EMITTER);
        }
        return stack;
    }

    @Override
    public StoredItemStack getEntityStack(IEntityNode node, int slot) {
        ArrayList storedStacks = new ArrayList();
        List<Entity> entityList = node.getEntities();
        for (Entity entity : entityList) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            InventoryPlayer inv = player.field_71071_by;
            if (slot >= inv.func_70302_i_()) continue;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null) {
                return null;
            }
            return new StoredItemStack(stack);
        }
        return null;
    }

    @Override
    public StoredItemStack getTileStack(INetworkCache network, int slot) {
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        for (Map.Entry entry : connections.entrySet()) {
            for (InventoryHandler provider : SonarCore.inventoryProviders.getObjects()) {
                TileEntity tile = ((BlockCoords)entry.getKey()).getTileEntity();
                if (tile == null || !provider.canHandleItems(tile, (ForgeDirection)entry.getValue())) continue;
                return provider.getStack(slot, tile, (ForgeDirection)entry.getValue());
            }
        }
        return null;
    }

    @Override
    public StoredItemStack addStackToPlayer(StoredItemStack add, EntityPlayer player, boolean enderChest, ActionType action) {
        if (add == null) {
            return null;
        }
        InventoryPlayer inv = null;
        int size = 0;
        if (!enderChest) {
            inv = player.field_71071_by;
            size = player.field_71071_by.field_70462_a.length;
        } else {
            inv = player.func_71005_bN();
            size = inv.func_70302_i_();
        }
        if (inv == null || size == 0) {
            return add;
        }
        ArrayList<Integer> empty = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack != null) {
                if (stack.field_77994_a >= stack.func_77976_d() || !add.equalStack(stack) || stack.field_77994_a >= inv.func_70297_j_()) continue;
                long used = Math.min((long)add.item.func_77976_d(), Math.min(add.stored, (long)(inv.func_70297_j_() - stack.field_77994_a)));
                stack.field_77994_a = (int)((long)stack.field_77994_a + used);
                add.stored -= used;
                if (used != 0L && !action.shouldSimulate()) {
                    inv.func_70299_a(i, stack);
                    if (!enderChest) {
                        SonarCore.network.sendTo((IMessage)new PacketInvUpdate(i, stack), (EntityPlayerMP)player);
                    }
                }
                if (add.stored != 0L) continue;
                return null;
            }
            empty.add(i);
        }
        for (Integer slot : empty) {
            int used;
            ItemStack stack = add.item.func_77946_l();
            if (!inv.func_94041_b(slot.intValue(), stack)) continue;
            stack.field_77994_a = used = (int)Math.min(add.stored, (long)inv.func_70297_j_());
            add.stored -= (long)used;
            if (!action.shouldSimulate()) {
                inv.func_70299_a(slot.intValue(), stack);
                if (!enderChest) {
                    SonarCore.network.sendTo((IMessage)new PacketInvUpdate(slot.intValue(), stack), (EntityPlayerMP)player);
                }
            }
            if (add.stored != 0L) continue;
            return null;
        }
        return add;
    }

    @Override
    public StoredItemStack removeStackFromPlayer(StoredItemStack remove, EntityPlayer player, boolean enderChest, ActionType action) {
        if (remove == null) {
            return null;
        }
        InventoryPlayer inv = null;
        int size = 0;
        if (!enderChest) {
            inv = player.field_71071_by;
            size = player.field_71071_by.field_70462_a.length;
        } else {
            inv = player.func_71005_bN();
            size = inv.func_70302_i_();
        }
        if (inv == null || size == 0) {
            return remove;
        }
        ArrayList empty = new ArrayList();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !remove.equalStack(stack)) continue;
            long used = Math.min(remove.stored, (long)Math.min(inv.func_70297_j_(), stack.field_77994_a));
            stack.field_77994_a = (int)((long)stack.field_77994_a - used);
            remove.stored -= used;
            if (!action.shouldSimulate()) {
                if (stack.field_77994_a == 0) {
                    stack = null;
                }
                inv.func_70299_a(i, stack);
            }
            if (remove.stored != 0L) continue;
            return null;
        }
        return remove;
    }

    @Override
    public StoredItemStack removeToPlayerInventory(StoredItemStack stack, long extractSize, INetworkCache network, EntityPlayer player, ActionType type) {
        StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(extractSize, stack, this.removeItems(stack.copy().setStackSize(extractSize), network, type));
        if (simulate == null) {
            return null;
        }
        StoredItemStack returned = SonarAPI.getItemHelper().getStackToAdd(stack.stored, simulate, this.addStackToPlayer(simulate.copy(), player, false, type));
        return returned;
    }

    @Override
    public StoredItemStack addFromPlayerInventory(StoredItemStack stack, long extractSize, INetworkCache network, EntityPlayer player, ActionType type) {
        StoredItemStack simulate = SonarAPI.getItemHelper().getStackToAdd(extractSize, stack, this.removeStackFromPlayer(stack.copy().setStackSize(extractSize), player, false, type));
        if (simulate == null) {
            return null;
        }
        StoredItemStack returned = SonarAPI.getItemHelper().getStackToAdd(stack.stored, simulate, this.addItems(simulate.copy(), network, type));
        return returned;
    }

    @Override
    public StoredItemStack extractItem(INetworkCache cache, StoredItemStack stack) {
        if (stack != null && stack.stored != 0L) {
            StoredItemStack extract = LogisticsAPI.getItemHelper().removeItems(stack.copy(), cache, ActionType.PERFORM);
            StoredItemStack toAdd = SonarAPI.getItemHelper().getStackToAdd(stack.getStackSize(), stack, extract);
            return toAdd;
        }
        return null;
    }

    @Override
    public void insertInventoryFromPlayer(EntityPlayer player, INetworkCache cache, int slotID) {
        ItemStack add = null;
        add = slotID == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slotID);
        if (add == null) {
            return;
        }
        StoredItemStack stack = new StoredItemStack(add).setStackSize(0L);
        InventoryPlayer inv = player.field_71071_by;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!stack.equalStack(item)) continue;
            stack.add(item);
            slots.add(i);
        }
        StoredItemStack remainder = LogisticsAPI.getItemHelper().addItems(stack.copy(), cache, ActionType.PERFORM);
        StoredItemStack toAdd = SonarAPI.getItemHelper().getStackToAdd(stack.getStackSize(), stack, remainder);
        LogisticsAPI.getItemHelper().removeStackFromPlayer(toAdd, player, false, ActionType.PERFORM);
    }

    @Override
    public void insertItemFromPlayer(EntityPlayer player, INetworkCache cache, int slot) {
        ItemStack add = player.field_71071_by.func_70301_a(slot);
        if (add == null) {
            return;
        }
        StoredItemStack stack = LogisticsAPI.getItemHelper().addItems(new StoredItemStack(add), cache, ActionType.PERFORM);
        if (stack == null || stack.stored == 0L) {
            add = null;
        } else {
            add.field_77994_a = (int)stack.stored;
        }
        if (!ItemStack.func_77989_b((ItemStack)add, (ItemStack)player.field_71071_by.func_70301_a(slot))) {
            player.field_71071_by.func_70299_a(slot, add);
        }
    }

    public static boolean writeStorageToNBT(NBTTagCompound tag, boolean lastWasNull, ItemWrapper.StorageItems stacks, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < stacks.items.size(); ++i) {
                if (stacks.items.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)stacks.items.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("c", (NBTBase)list);
                return false;
            }
            tag.func_74757_a("n", true);
            return true;
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (stacks.items == null || stacks.items.isEmpty()) {
                if (!lastWasNull) {
                    tag.func_74757_a("n", true);
                }
                return true;
            }
            NBTTagList list = new NBTTagList();
            for (int l = 0; l < 2; ++l) {
                ArrayList<StoredItemStack> stackList = null;
                switch (l) {
                    case 0: {
                        stackList = stacks.changed;
                        break;
                    }
                    case 1: {
                        stackList = stacks.removed;
                    }
                }
                for (int i = 0; i < stackList.size(); ++i) {
                    if (stackList.get(i) == null) continue;
                    NBTTagCompound compound = new NBTTagCompound();
                    if (l == 1) {
                        compound.func_74757_a("r", true);
                    }
                    StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)stackList.get(i));
                    list.func_74742_a((NBTBase)compound);
                }
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("s", (NBTBase)list);
            }
        }
        return false;
    }

    public static void readStorageToNBT(NBTTagCompound tag, ArrayList<StoredItemStack> current, NBTHelper.SyncType type) {
        block8: {
            block7: {
                if (tag.func_74764_b("n")) {
                    current.clear();
                    return;
                }
                if (type != NBTHelper.SyncType.SYNC) break block7;
                if (!tag.func_74764_b("c")) {
                    return;
                }
                NBTTagList list = tag.func_150295_c("c", 10);
                current.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    current.add(StoredItemStack.readFromNBT((NBTTagCompound)compound));
                }
                break block8;
            }
            if (type != NBTHelper.SyncType.SPECIAL) break block8;
            if (!tag.func_74764_b("s")) {
                return;
            }
            NBTTagList list = tag.func_150295_c("s", 10);
            block1: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                StoredItemStack stack = StoredItemStack.readFromNBT((NBTTagCompound)compound);
                for (StoredItemStack stored : (ArrayList)current.clone()) {
                    if (!stored.equalStack(stack.getItemStack())) continue;
                    if (compound.func_74767_n("r")) {
                        current.remove(stored);
                        continue block1;
                    }
                    stored.setStackSize(stack.getStackSize());
                    continue block1;
                }
                current.add(stack);
            }
        }
    }

    public static void sortItemList(ArrayList<StoredItemStack> current, final ItemWrapper.SortingDirection dir, ItemWrapper.SortingType type) {
        current.sort(new Comparator<StoredItemStack>(){

            @Override
            public int compare(StoredItemStack str1, StoredItemStack str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getItemStack().func_82833_r(), str2.getItemStack().func_82833_r());
                if (res == 0) {
                    res = str1.getItemStack().func_82833_r().compareTo(str2.getItemStack().func_82833_r());
                }
                return dir == ItemWrapper.SortingDirection.DOWN ? res : -res;
            }
        });
        switch (type) {
            case STORED: {
                current.sort(new Comparator<StoredItemStack>(){

                    @Override
                    public int compare(StoredItemStack str1, StoredItemStack str2) {
                        if (str1.stored < str2.stored) {
                            return dir == ItemWrapper.SortingDirection.DOWN ? 1 : -1;
                        }
                        if (str1.stored == str2.stored) {
                            return 0;
                        }
                        return dir == ItemWrapper.SortingDirection.DOWN ? -1 : 1;
                    }
                });
                break;
            }
            case MODID: {
                current.sort(new Comparator<StoredItemStack>(){

                    @Override
                    public int compare(StoredItemStack str1, StoredItemStack str2) {
                        GameRegistry.UniqueIdentifier ui1 = GameRegistry.findUniqueIdentifierFor((Item)str1.getItemStack().func_77973_b());
                        GameRegistry.UniqueIdentifier ui2 = GameRegistry.findUniqueIdentifierFor((Item)str2.getItemStack().func_77973_b());
                        int res = String.CASE_INSENSITIVE_ORDER.compare(ui1.modId, ui2.modId);
                        if (res == 0) {
                            res = ui1.modId.compareTo(ui2.modId);
                        }
                        return dir == ItemWrapper.SortingDirection.DOWN ? res : -res;
                    }
                });
            }
        }
    }
}

