/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.api.wrappers.RenderWrapper;

public class InfoRenderer
extends RenderWrapper {
    @Override
    public void renderStandardInfo(ILogicInfo info, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + (maxY - minY) / 2.0f), (float)0.01f);
        int sizing = Math.round(Math.min(maxX - minX, (maxY - minY) * 3.0f));
        GL11.glTranslatef((float)0.0f, (float)((float)(type.isNormalSize() ? (double)-0.1f : (double)-0.2f + (double)(sizing - 1) * -0.01)), (float)zOffset);
        double itemScale = sizing >= 2 ? this.getScale(sizing) : 120.0;
        GL11.glScaled((double)(1.0 / itemScale), (double)(1.0 / itemScale), (double)(1.0 / itemScale));
        String category = info.getSubCategory();
        String data = info.getDisplayableData();
        if (category.isEmpty() || category.equals(" ")) {
            rend.func_78276_b(data, -rend.func_78256_a(data) / 2, -4, -1);
        } else {
            rend.func_78276_b(category, -rend.func_78256_a(category) / 2, -8, -1);
            rend.func_78276_b(data, -rend.func_78256_a(data) / 2, 4, -1);
        }
        GL11.glScaled((double)itemScale, (double)itemScale, (double)itemScale);
    }

    @Override
    public void renderCenteredString(String string, float minX, float minY, float maxX, float maxY, ScreenType type) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + (maxY - minY) / 2.0f), (float)0.01f);
        int sizing = Math.round(Math.min(maxX - minX, (maxY - minY) * 3.0f));
        GL11.glTranslatef((float)0.0f, (float)((float)(type.isNormalSize() ? (double)-0.08f : (double)-0.2f + (double)(sizing - 1) * 0.001)), (float)0.0f);
        double itemScale = sizing >= 2 ? this.getScale(sizing) : 120.0;
        GL11.glScaled((double)(1.0 / itemScale), (double)(1.0 / itemScale), (double)(1.0 / itemScale));
        rend.func_78276_b(string, -rend.func_78256_a(string) / 2, -4, -1);
    }

    @Override
    public float getScaling(ScreenType type) {
        switch (type) {
            case LARGE: {
                return 110.0f;
            }
            case CONNECTED: {
                return 40.0f;
            }
        }
        return 120.0f;
    }

    @Override
    public double getScale(int sizing) {
        switch (sizing) {
            case 0: {
                return 120.0;
            }
            case 2: {
                return 70.0;
            }
            case 3: {
                return 40.0;
            }
            case 4: {
                return 30.0;
            }
            case 5: {
                return 22.0;
            }
        }
        return 18.0;
    }
}

