/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.providers.EntityProvider;
import sonar.logistics.api.providers.TileProvider;
import sonar.logistics.api.wrappers.InfoWrapper;
import sonar.logistics.info.types.CategoryInfo;
import sonar.logistics.info.types.FluidInfo;
import sonar.logistics.info.types.ProgressInfo;

public class InfoHelper
extends InfoWrapper {
    public static final LogicInfo empty = new LogicInfo(-1, "INFO", " ", (Object)"NO DATA");

    @Override
    public ArrayList<ILogicInfo> getTileInfo(INetworkCache connections) {
        List providers = Logistics.tileProviders.getObjects();
        ArrayList<ILogicInfo> providerInfo = new ArrayList<ILogicInfo>();
        LinkedHashMap<BlockCoords, ForgeDirection> map = connections.getExternalBlocks(true);
        for (TileProvider provider : providers) {
            Map.Entry<BlockCoords, ForgeDirection> entry;
            BlockCoords coords;
            Iterator<Map.Entry<BlockCoords, ForgeDirection>> iterator = map.entrySet().iterator();
            if (!iterator.hasNext() || !provider.canProvideInfo((coords = (entry = iterator.next()).getKey()).getWorld(), coords.getX(), coords.getY(), coords.getZ(), entry.getValue())) continue;
            ArrayList<ILogicInfo> info = new ArrayList<ILogicInfo>();
            provider.getTileInfo(info, coords.getWorld(), coords.getX(), coords.getY(), coords.getZ(), entry.getValue());
            for (ILogicInfo blockInfo : info) {
                providerInfo.add(blockInfo);
            }
        }
        Collections.sort(providerInfo, new Comparator<ILogicInfo>(){

            @Override
            public int compare(ILogicInfo str1, ILogicInfo str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getCategory(), str2.getCategory());
                if (res == 0) {
                    res = str1.getCategory().compareTo(str2.getCategory());
                }
                return res;
            }
        });
        return providerInfo;
    }

    @Override
    public ArrayList<ILogicInfo> getEntityInfo(IEntityNode tileNode) {
        List providers = Logistics.entityProviders.getObjects();
        ArrayList<ILogicInfo> providerInfo = new ArrayList<ILogicInfo>();
        List<Entity> entityList = tileNode.getEntities();
        for (EntityProvider provider : providers) {
            for (Entity entity : entityList) {
                if (entity == null || !provider.canProvideInfo(entity)) continue;
                ArrayList<ILogicInfo> info = new ArrayList<ILogicInfo>();
                provider.getHelperInfo(info, entity);
                for (ILogicInfo blockInfo : info) {
                    providerInfo.add(blockInfo);
                }
            }
        }
        Collections.sort(providerInfo, new Comparator<ILogicInfo>(){

            @Override
            public int compare(ILogicInfo str1, ILogicInfo str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getCategory(), str2.getCategory());
                if (res == 0) {
                    res = str1.getCategory().compareTo(str2.getCategory());
                }
                return res;
            }
        });
        return providerInfo;
    }

    @Override
    public ILogicInfo getLatestTileInfo(ILogicInfo tileInfo, INetworkCache network) {
        Map.Entry entry;
        BlockCoords coords;
        if (network == null || tileInfo == null) {
            return null;
        }
        TileProvider provider = (TileProvider)Logistics.tileProviders.getRegisteredObject(tileInfo.getProviderID());
        if (provider == null) {
            return null;
        }
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        Iterator iterator = connections.entrySet().iterator();
        if (iterator.hasNext() && provider.canProvideInfo((coords = (BlockCoords)(entry = iterator.next()).getKey()).getWorld(), coords.getX(), coords.getY(), coords.getZ(), (ForgeDirection)entry.getValue())) {
            ArrayList<ILogicInfo> info = new ArrayList<ILogicInfo>();
            provider.getTileInfo(info, coords.getWorld(), coords.getX(), coords.getY(), coords.getZ(), (ForgeDirection)entry.getValue());
            for (ILogicInfo currentInfo : info) {
                if (!currentInfo.isMatchingInfo(tileInfo)) continue;
                return currentInfo;
            }
        }
        return null;
    }

    @Override
    public ILogicInfo getLatestEntityInfo(ILogicInfo entityInfo, IEntityNode entityNode) {
        Entity entity;
        Iterator<Entity> iterator;
        if (entityInfo == null) {
            return null;
        }
        List<Entity> entityList = entityNode.getEntities();
        EntityProvider provider = (EntityProvider)Logistics.entityProviders.getRegisteredObject(entityInfo.getProviderID());
        if (provider != null && (iterator = entityList.iterator()).hasNext() && (entity = iterator.next()) != null && provider.canProvideInfo(entity)) {
            ArrayList<ILogicInfo> info = new ArrayList<ILogicInfo>();
            provider.getHelperInfo(info, entity);
            for (ILogicInfo currentInfo : info) {
                if (!currentInfo.isMatchingInfo(entityInfo)) continue;
                return currentInfo;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ILogicInfo combineData(ILogicInfo primary, ILogicInfo secondary) {
        if (primary instanceof CategoryInfo || secondary instanceof CategoryInfo) return new LogicInfo(-1, primary.getCategory(), "Combined Data", (Object)(primary.getDisplayableData() + secondary.getDisplayableData()));
        if (primary.getDataType() != 0 || secondary.getDataType() != 0) return primary;
        long stored = Long.parseLong(secondary.getData());
        long max = Long.parseLong(primary.getData());
        if (stored < 0L || max < 0L) {
            return primary;
        }
        int fluidId = -1;
        if (primary instanceof FluidInfo) {
            FluidInfo fluidinfo = (FluidInfo)primary;
            fluidId = fluidinfo.fluidID;
        }
        if (stored > max && stored != 0L) {
            return new ProgressInfo(max, stored, primary.getDisplayableData(), fluidId);
        }
        if (max == 0L) return primary;
        return new ProgressInfo(stored, max, secondary.getDisplayableData(), fluidId);
    }

    public static boolean writeInfoToNBT(NBTTagCompound tag, ArrayList<ILogicInfo> current, ArrayList<ILogicInfo> last, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SYNC})) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < current.size(); ++i) {
                if (current.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                Logistics.infoTypes.writeToNBT(compound, current.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("c", (NBTBase)list);
                return false;
            }
            tag.func_74757_a("n", true);
            return true;
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL})) {
            if (current == null || current.isEmpty()) {
                if (last != null && !last.isEmpty()) {
                    tag.func_74757_a("n", true);
                }
                return true;
            }
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < current.size(); ++i) {
                ILogicInfo info = current.get(i);
                if (info == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                boolean full = true;
                if (i < last.size()) {
                    ILogicInfo lastInfo = last.get(i);
                    NBTHelper.SyncType sync = lastInfo.getNextSyncType(info);
                    if (sync == null) continue;
                    switch (sync) {
                        case SYNC: {
                            lastInfo.writeUpdate(info, compound);
                            full = false;
                            break;
                        }
                    }
                }
                if (full) {
                    Logistics.infoTypes.writeToNBT(compound, current.get(i));
                } else {
                    compound.func_74757_a("up", true);
                }
                compound.func_74768_a("pos", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("s", (NBTBase)list);
            }
        }
        return false;
    }

    public static void readStorageToNBT(NBTTagCompound tag, ArrayList<ILogicInfo> current, NBTHelper.SyncType type) {
        block8: {
            block7: {
                if (tag.func_74764_b("n")) {
                    current.clear();
                    return;
                }
                if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SYNC})) break block7;
                if (!tag.func_74764_b("c")) {
                    return;
                }
                NBTTagList list = tag.func_150295_c("c", 10);
                current.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    current.add((ILogicInfo)Logistics.infoTypes.readFromNBT(compound));
                }
                break block8;
            }
            if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL})) break block8;
            if (!tag.func_74764_b("s")) {
                return;
            }
            NBTTagList list = tag.func_150295_c("s", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                int j = compound.func_74762_e("pos");
                if (j < current.size()) {
                    if (compound.func_74767_n("up")) {
                        current.get(j).readUpdate(compound);
                        continue;
                    }
                    ILogicInfo info = current.get(j);
                    info = (ILogicInfo)Logistics.infoTypes.readFromNBT(compound);
                    if (info == null) continue;
                    current.add(j, info);
                    continue;
                }
                current.set(j, (ILogicInfo)Logistics.infoTypes.readFromNBT(compound));
            }
        }
    }

    public static ArrayList<ILogicInfo> sortInfoList(ArrayList<ILogicInfo> current) {
        ArrayList<ILogicInfo> newInfo = new ArrayList<ILogicInfo>();
        ILogicInfo lastInfo = null;
        for (ILogicInfo blockInfo : (ArrayList)current.clone()) {
            if (lastInfo == null || !lastInfo.getCategory().equals(blockInfo.getCategory())) {
                newInfo.add(CategoryInfo.createInfo(blockInfo.getCategory()));
            }
            if (blockInfo.getDataType() != -2) {
                newInfo.add(blockInfo);
            }
            lastInfo = blockInfo;
        }
        return newInfo;
    }
}

