/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import sonar.core.SonarCore;
import sonar.core.api.ActionType;
import sonar.core.api.BlockCoords;
import sonar.core.api.FluidHandler;
import sonar.core.api.StoredFluidStack;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.cache.IStorageCache;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;

public class FluidHelper
extends FluidWrapper {
    @Override
    public FluidWrapper.StorageFluids getFluids(INetworkCache network) {
        if (network instanceof IStorageCache) {
            FluidWrapper.StorageFluids stored = ((IStorageCache)network).getStoredFluids();
            return stored;
        }
        return FluidWrapper.StorageFluids.EMPTY;
    }

    @Override
    public StoredFluidStack addFluids(StoredFluidStack add, INetworkCache network, ActionType action) {
        if (add.stored == 0L) {
            return add;
        }
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        for (Map.Entry entry : connections.entrySet()) {
            TileEntity tile = ((BlockCoords)entry.getKey()).getTileEntity();
            for (FluidHandler provider : SonarCore.fluidProviders.getObjects()) {
                if (!provider.canHandleFluids(tile, (ForgeDirection)entry.getValue()) || (add = provider.addStack(add, tile, (ForgeDirection)entry.getValue(), action)) != null) continue;
                return null;
            }
        }
        return add;
    }

    @Override
    public StoredFluidStack removeFluids(StoredFluidStack remove, INetworkCache network, ActionType action) {
        if (remove.stored == 0L) {
            return remove;
        }
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        for (Map.Entry entry : connections.entrySet()) {
            TileEntity tile = ((BlockCoords)entry.getKey()).getTileEntity();
            for (FluidHandler provider : SonarCore.fluidProviders.getObjects()) {
                if (!provider.canHandleFluids(tile, (ForgeDirection)entry.getValue()) || (remove = provider.removeStack(remove, tile, (ForgeDirection)entry.getValue(), action)) != null) continue;
                return null;
            }
        }
        return remove;
    }

    @Override
    public ItemStack fillFluidItemStack(ItemStack container, StoredFluidStack fill, INetworkCache network, ActionType action) {
        if (FluidContainerRegistry.isContainer((ItemStack)container)) {
            return this.fillFluidContainer(container, fill, network, action);
        }
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            return this.fillFluidHandler(container, fill, network, action);
        }
        return container;
    }

    @Override
    public ItemStack drainFluidItemStack(ItemStack container, INetworkCache network, ActionType action) {
        if (FluidContainerRegistry.isContainer((ItemStack)container)) {
            return this.drainFluidContainer(container, network, action);
        }
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            return this.drainFluidHandler(container, network, action);
        }
        return container;
    }

    public ItemStack fillFluidContainer(ItemStack container, StoredFluidStack fill, INetworkCache network, ActionType action) {
        FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        int extractSize = 0;
        if (stack != null && stack.isFluidEqual(fill.fluid)) {
            extractSize = FluidContainerRegistry.getContainerCapacity((ItemStack)container) - stack.amount;
        } else if (stack == null) {
            extractSize = container.func_77973_b() == Items.field_151133_ar ? 1000 : FluidContainerRegistry.getContainerCapacity((ItemStack)container);
        }
        if (extractSize == 0) {
            return container;
        }
        StoredFluidStack remainder = this.removeFluids(fill.setStackSize((long)extractSize), network, action);
        FluidStack fillStack = fill.fluid.copy();
        fillStack.amount = remainder == null || remainder.stored == 0L ? extractSize : (int)((long)extractSize - remainder.stored);
        ItemStack filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)fillStack, (ItemStack)container);
        if (filledStack != null) {
            container = filledStack;
        }
        return container;
    }

    public ItemStack drainFluidContainer(ItemStack container, INetworkCache network, ActionType action) {
        StoredFluidStack remainder;
        FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (stack != null && ((remainder = this.addFluids(new StoredFluidStack(stack), network, action)) == null || remainder.stored == 0L)) {
            container = FluidContainerRegistry.drainFluidContainer((ItemStack)container);
        }
        return container;
    }

    public ItemStack fillFluidHandler(ItemStack handler, StoredFluidStack fill, INetworkCache network, ActionType action) {
        IFluidContainerItem container = (IFluidContainerItem)handler.func_77973_b();
        FluidStack stack = container.getFluid(handler);
        int extractSize = 0;
        if (stack != null && stack.isFluidEqual(fill.fluid)) {
            extractSize = (int)Math.min(fill.stored, (long)(container.getCapacity(handler) - stack.amount));
        } else if (stack == null) {
            extractSize = container.fill(handler, fill.getFullStack(), false);
        }
        if (extractSize == 0) {
            return handler;
        }
        StoredFluidStack remainder = LogisticsAPI.getFluidHelper().removeFluids(fill.setStackSize((long)extractSize), network, action);
        FluidStack fillStack = fill.fluid.copy();
        fillStack.amount = remainder == null || remainder.stored == 0L ? extractSize : (int)((long)extractSize - remainder.stored);
        container.fill(handler, fillStack, true);
        return handler;
    }

    public ItemStack drainFluidHandler(ItemStack handler, INetworkCache network, ActionType action) {
        IFluidContainerItem container = (IFluidContainerItem)handler.func_77973_b();
        FluidStack stack = container.getFluid(handler);
        if (stack != null) {
            FluidStack insertSize = container.drain(handler, Integer.MAX_VALUE, false);
            StoredFluidStack remainder = this.addFluids(new StoredFluidStack(insertSize), network, action);
            int drainSize = 0;
            drainSize = remainder == null || remainder.stored == 0L ? insertSize.amount : (int)((long)insertSize.amount - remainder.stored);
            container.drain(handler, drainSize, true);
        }
        return handler;
    }

    @Override
    public void fillHeldItem(EntityPlayer player, INetworkCache cache, StoredFluidStack toFill) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || toFill == null) {
            return;
        }
        if (heldItem.field_77994_a == 1) {
            ItemStack simulate = LogisticsAPI.getFluidHelper().fillFluidItemStack(heldItem.func_77946_l(), toFill.copy(), cache, ActionType.SIMULATE);
            if (!ItemStack.func_77989_b((ItemStack)simulate, (ItemStack)heldItem) || !ItemStack.func_77970_a((ItemStack)simulate, (ItemStack)heldItem)) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, LogisticsAPI.getFluidHelper().fillFluidItemStack(heldItem, toFill, cache, ActionType.PERFORM));
            }
        } else {
            ItemStack insert = heldItem.func_77946_l();
            insert.field_77994_a = 1;
            ItemStack simulate = LogisticsAPI.getFluidHelper().fillFluidItemStack(insert.func_77946_l(), toFill.copy(), cache, ActionType.SIMULATE);
            if (!ItemStack.func_77989_b((ItemStack)simulate, (ItemStack)insert) || !ItemStack.func_77970_a((ItemStack)simulate, (ItemStack)insert)) {
                ItemStack toAdd = LogisticsAPI.getFluidHelper().fillFluidItemStack(insert, toFill, cache, ActionType.PERFORM);
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                StoredItemStack storedItemStack = LogisticsAPI.getItemHelper().addStackToPlayer(new StoredItemStack(toAdd), player, false, ActionType.PERFORM);
            }
        }
    }

    @Override
    public void drainHeldItem(EntityPlayer player, INetworkCache cache) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        ItemStack insert = heldItem.func_77946_l();
        insert.field_77994_a = 1;
        ItemStack empty = LogisticsAPI.getFluidHelper().drainFluidItemStack(insert.func_77946_l(), cache, ActionType.PERFORM);
        if (!player.field_71075_bZ.field_75098_d) {
            if (insert.field_77994_a == heldItem.field_77994_a) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, empty);
            } else {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                if (empty != null) {
                    LogisticsAPI.getItemHelper().addStackToPlayer(new StoredItemStack(empty), player, false, ActionType.PERFORM);
                }
            }
        }
    }

    public static boolean writeStorageToNBT(NBTTagCompound tag, boolean lastWasNull, FluidWrapper.StorageFluids stacks, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < stacks.fluids.size(); ++i) {
                if (stacks.fluids.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                StoredFluidStack.writeToNBT((NBTTagCompound)compound, (StoredFluidStack)stacks.fluids.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("c", (NBTBase)list);
                return false;
            }
            tag.func_74757_a("n", true);
            return true;
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (stacks.fluids == null || stacks.fluids.isEmpty()) {
                if (!lastWasNull) {
                    tag.func_74757_a("n", true);
                }
                return true;
            }
            NBTTagList list = new NBTTagList();
            for (int l = 0; l < 2; ++l) {
                ArrayList<StoredFluidStack> stackList = null;
                switch (l) {
                    case 0: {
                        stackList = stacks.changed;
                        break;
                    }
                    case 1: {
                        stackList = stacks.removed;
                    }
                }
                for (int i = 0; i < stackList.size(); ++i) {
                    if (stackList.get(i) == null) continue;
                    NBTTagCompound compound = new NBTTagCompound();
                    if (l == 1) {
                        compound.func_74757_a("r", true);
                    }
                    StoredFluidStack.writeToNBT((NBTTagCompound)compound, (StoredFluidStack)stackList.get(i));
                    list.func_74742_a((NBTBase)compound);
                }
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a("s", (NBTBase)list);
            }
        }
        return false;
    }

    public static void readStorageToNBT(NBTTagCompound tag, ArrayList<StoredFluidStack> current, NBTHelper.SyncType type) {
        block8: {
            block7: {
                if (tag.func_74764_b("n")) {
                    current.clear();
                    return;
                }
                if (type != NBTHelper.SyncType.SYNC) break block7;
                if (!tag.func_74764_b("c")) {
                    return;
                }
                NBTTagList list = tag.func_150295_c("c", 10);
                current.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    current.add(StoredFluidStack.readFromNBT((NBTTagCompound)compound));
                }
                break block8;
            }
            if (type != NBTHelper.SyncType.SPECIAL) break block8;
            if (!tag.func_74764_b("s")) {
                return;
            }
            NBTTagList list = tag.func_150295_c("s", 10);
            block1: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                StoredFluidStack stack = StoredFluidStack.readFromNBT((NBTTagCompound)compound);
                for (StoredFluidStack stored : (ArrayList)current.clone()) {
                    if (!stored.equalStack(stack.getFullStack())) continue;
                    if (compound.func_74767_n("r")) {
                        current.remove(stored);
                        continue block1;
                    }
                    stored.setStackSize(stack.stored);
                    continue block1;
                }
                current.add(stack);
            }
        }
    }

    public static void sortFluidList(ArrayList<StoredFluidStack> current, final ItemWrapper.SortingDirection dir, ItemWrapper.SortingType type) {
        current.sort(new Comparator<StoredFluidStack>(){

            @Override
            public int compare(StoredFluidStack str1, StoredFluidStack str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getFullStack().getLocalizedName(), str2.getFullStack().getLocalizedName());
                if (res == 0) {
                    res = str1.getFullStack().getLocalizedName().compareTo(str2.getFullStack().getLocalizedName());
                }
                return dir == ItemWrapper.SortingDirection.DOWN ? res : -res;
            }
        });
        switch (type) {
            case STORED: {
                current.sort(new Comparator<StoredFluidStack>(){

                    @Override
                    public int compare(StoredFluidStack str1, StoredFluidStack str2) {
                        if (str1.stored < str2.stored) {
                            return dir == ItemWrapper.SortingDirection.DOWN ? 1 : -1;
                        }
                        if (str1.stored == str2.stored) {
                            return 0;
                        }
                        return dir == ItemWrapper.SortingDirection.DOWN ? -1 : 1;
                    }
                });
                break;
            }
            case MODID: {
                current.sort(new Comparator<StoredFluidStack>(){

                    @Override
                    public int compare(StoredFluidStack str1, StoredFluidStack str2) {
                        if (str1.getFullStack().getFluid().getTemperature() < str2.getFullStack().getFluid().getTemperature()) {
                            return dir == ItemWrapper.SortingDirection.DOWN ? 1 : -1;
                        }
                        if (str1.getFullStack().getFluid().getTemperature() == str2.getFullStack().getFluid().getTemperature()) {
                            return 0;
                        }
                        return dir == ItemWrapper.SortingDirection.DOWN ? -1 : 1;
                    }
                });
            }
        }
    }
}

