/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.api.EnergyHandler;
import sonar.core.api.EnergyType;
import sonar.core.api.StoredEnergyStack;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.utils.IdentifiedCoords;
import sonar.logistics.api.wrappers.EnergyWrapper;
import sonar.logistics.info.types.StoredEnergyInfo;

public class EnergyHelper
extends EnergyWrapper {
    @Override
    public List<StoredEnergyInfo> getEnergyList(INetworkCache network) {
        ArrayList<StoredEnergyInfo> energyList = new ArrayList<StoredEnergyInfo>();
        LinkedHashMap<BlockCoords, ForgeDirection> connections = network.getExternalBlocks(true);
        block0: for (Map.Entry entry : connections.entrySet()) {
            TileEntity energyTile = ((BlockCoords)entry.getKey()).getTileEntity();
            if (energyTile == null) continue;
            for (EnergyType type : SonarCore.energyTypes.getObjects()) {
                StoredEnergyStack stack = new StoredEnergyStack(type);
                boolean provided = false;
                for (EnergyHandler handler : this.getProviders(type)) {
                    if (!handler.canProvideEnergy(energyTile, (ForgeDirection)entry.getValue())) continue;
                    handler.getEnergy(stack, energyTile, (ForgeDirection)entry.getValue());
                    provided = true;
                }
                if (!provided) continue;
                IdentifiedCoords iCoords = new IdentifiedCoords("", SonarHelper.createStackedBlock((Block)energyTile.func_145838_q(), (int)energyTile.func_145832_p()), (BlockCoords)entry.getKey());
                energyList.add(StoredEnergyInfo.createInfo(iCoords, stack));
                continue block0;
            }
        }
        return energyList;
    }

    public List<EnergyHandler> getProviders(EnergyType type) {
        ArrayList<EnergyHandler> providers = new ArrayList<EnergyHandler>();
        List handlers = SonarCore.energyProviders.getObjects();
        for (EnergyHandler provider : handlers) {
            if (!provider.getProvidedType().getName().equals(type.getName())) continue;
            providers.add(provider);
        }
        return providers;
    }
}

