/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.registries.DisplayRegistry;

public class DisplayHelper {
    public static void addScreen(ILargeDisplay screen) {
        TileEntity screenTile = screen.getCoords().getTileEntity();
        if (screenTile != null) {
            ArrayList<TileEntity> adjacents = new ArrayList<TileEntity>();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                ILargeDisplay adjTile;
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                TileEntity adjacent = BlockCoords.translateCoords((BlockCoords)screen.getCoords(), (ForgeDirection)dir).getTileEntity();
                if (dir == ForgeDirection.getOrientation((int)screen.getOrientation()) || adjacent == null || !(adjacent instanceof ILargeDisplay) || (adjTile = (ILargeDisplay)adjacent).getOrientation() != screen.getOrientation() || adjTile.registryID() == -2) continue;
                adjacents.add(adjacent);
                ids.add(adjTile.registryID());
            }
            int screenID = -1;
            int lastSize = -1;
            for (Integer id : ids) {
                List<BlockCoords> list;
                if (id == -1 || (list = DisplayRegistry.getScreens(id)).size() <= lastSize) continue;
                screenID = id;
                lastSize = list.size();
            }
            if (screenID == -1) {
                screenID = DisplayRegistry.getNextAvailableID();
            }
            DisplayRegistry.addScreen(screenID, screen.getCoords());
            ArrayList coords = new ArrayList();
            for (Object e : adjacents) {
                ILargeDisplay adjScreen;
                if (!(e instanceof ILargeDisplay) || (adjScreen = (ILargeDisplay)e).registryID() == screenID) continue;
                DisplayRegistry.connectScreens(screenID, adjScreen.registryID());
            }
        }
    }

    public static void removeScreen(ILargeDisplay screen) {
        DisplayRegistry.removeScreen(screen.registryID(), screen);
    }

    public static LargeScreenSizing getScreenSizing(TileEntity tile) {
        int minH;
        TileHandler tileObj = FMPHelper.getHandler((Object)FMPHelper.checkObject((Object)tile));
        if (tileObj == null || !(tileObj instanceof LargeDisplayScreenHandler)) {
            return null;
        }
        LargeDisplayScreenHandler remove = (LargeDisplayScreenHandler)tileObj;
        int maxX = tile.field_145851_c;
        int maxY = tile.field_145848_d;
        int maxZ = tile.field_145849_e;
        int minX = tile.field_145851_c;
        int minY = tile.field_145848_d;
        int minZ = tile.field_145849_e;
        int meta = tile.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta).getRotation(ForgeDirection.UP);
        boolean north = false;
        if (dir.offsetX == -1 || dir.offsetX == 1) {
            north = true;
        }
        int screens = 0;
        List<BlockCoords> displays = DisplayRegistry.getScreens(remove.registryID);
        if (displays != null) {
            for (BlockCoords coords : displays) {
                ++screens;
                if (coords.getX() > maxX) {
                    maxX = coords.getX();
                } else if (coords.getX() < minX) {
                    minX = coords.getX();
                }
                if (coords.getY() > maxY) {
                    maxY = coords.getY();
                } else if (coords.getY() < minY) {
                    minY = coords.getY();
                }
                if (coords.getZ() > maxZ) {
                    maxZ = coords.getZ();
                    continue;
                }
                if (coords.getZ() >= minZ) continue;
                minZ = coords.getZ();
            }
        }
        int maxH = north ? maxX : maxZ;
        for (int h = minH = north ? minX : minZ; h <= maxH; ++h) {
            for (int y = minY; y <= maxY; ++y) {
                BlockCoords coords = new BlockCoords(north ? h : tile.field_145851_c, y, !north ? h : tile.field_145849_e);
                TileEntity target = coords.getTileEntity(tile.func_145831_w());
                TileHandler targetObj = FMPHelper.getHandler((Object)target);
                if (targetObj != null && targetObj instanceof LargeDisplayScreenHandler && target.func_145832_p() == meta) continue;
                return null;
            }
        }
        minY = tile.field_145848_d - minY;
        return new LargeScreenSizing(maxY -= tile.field_145848_d, minY, maxH -= north ? tile.field_145851_c : tile.field_145849_e, minH -= north ? tile.field_145851_c : tile.field_145849_e);
    }
}

