/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ITextField;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.common.blocks.BlockRedstoneSignaller;
import sonar.logistics.registries.BlockRegistry;

public class TileEntityRedstoneSignaller
extends TileEntitySonar
implements ILogicTile,
IByteBufTile,
ITextField {
    public ILogicInfo currentInfo;
    public SyncTagType.INT integerEmitType = new SyncTagType.INT(0);
    public SyncTagType.INT integerTarget = new SyncTagType.INT(1);
    public SyncTagType.INT dataType = new SyncTagType.INT(2);
    public SyncTagType.INT errorFlag = new SyncTagType.INT(3);
    public SyncTagType.STRING stringName = new SyncTagType.STRING(4);

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite() == dir;
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType[]{this.stringName, this.integerEmitType, this.integerTarget, this.dataType, this.errorFlag}));
    }

    public void func_145845_h() {
        if (this.isServer()) {
            boolean canEmit;
            BlockRedstoneSignaller block = (BlockRedstoneSignaller)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean isOn = block == BlockRegistry.redstoneSignaller_on;
            if (isOn != (canEmit = this.canEmit())) {
                BlockRedstoneSignaller.updateSignallerState(canEmit, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            boolean setNull = true;
            INetworkCache network = LogisticsAPI.getCableHelper().getNetwork((TileEntity)this, ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite());
            Object object = FMPHelper.getTile((Object)network.getFirstTileEntity(CacheTypes.EMITTER));
            if (object != null && object instanceof IInfoEmitter) {
                IInfoEmitter infoNode = (IInfoEmitter)object;
                this.currentInfo = infoNode.currentInfo();
                setNull = false;
            }
            if (setNull) {
                this.currentInfo = null;
            }
        }
    }

    public boolean maxRender() {
        return true;
    }

    public boolean canEmit() {
        if (this.currentInfo != null) {
            if (this.currentInfo.getDataType() == ((Integer)this.dataType.getObject()).intValue()) {
                if ((Integer)this.dataType.getObject() == 0) {
                    this.errorFlag.setObject((Object)0);
                    long integer = Long.parseLong(this.currentInfo.getData());
                    switch ((Integer)this.integerEmitType.getObject()) {
                        case 0: {
                            return integer == (long)((Integer)this.integerTarget.getObject()).intValue();
                        }
                        case 1: {
                            return integer > (long)((Integer)this.integerTarget.getObject()).intValue();
                        }
                        case 2: {
                            return integer < (long)((Integer)this.integerTarget.getObject()).intValue();
                        }
                        case 3: {
                            return integer != (long)((Integer)this.integerTarget.getObject()).intValue();
                        }
                    }
                } else if ((Integer)this.dataType.getObject() == 1) {
                    this.errorFlag.setObject((Object)0);
                    return this.currentInfo.getData().equals(this.stringName.getObject());
                }
            } else {
                this.errorFlag.setObject((Object)2);
            }
        } else {
            this.errorFlag.setObject((Object)1);
            return false;
        }
        return false;
    }

    public void textTyped(String string, int id) {
        if (id == 0) {
            if (string == null || string.isEmpty()) {
                this.integerTarget.setObject((Object)0);
            } else {
                this.integerTarget.setObject((Object)Integer.parseInt(string));
            }
        }
        if (id == 1) {
            if (string == null || string.isEmpty()) {
                this.stringName.setObject((Object)"Unnamed Emitter");
            } else {
                this.stringName.setObject((Object)string);
            }
        }
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this);
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeInt(((Integer)this.dataType.getObject()).intValue());
                break;
            }
            case 1: {
                buf.writeInt(((Integer)this.integerEmitType.getObject()).intValue());
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.dataType.setObject((Object)buf.readInt());
                break;
            }
            case 1: {
                this.integerEmitType.setObject((Object)buf.readInt());
            }
        }
    }
}

